/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest.profile;

import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.coord.ClusterCoordinator;
import org.apache.drill.exec.coord.store.TransientStore;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.server.QueryProfileStoreContext;
import org.apache.drill.exec.server.rest.DrillRestServer;
import org.apache.drill.exec.server.rest.ViewableWithPermissions;
import org.apache.drill.exec.server.rest.auth.DrillUserPrincipal;
import org.apache.drill.exec.server.rest.profile.ProfileUtil;
import org.apache.drill.exec.server.rest.profile.ProfileWrapper;
import org.apache.drill.exec.server.rest.profile.SimpleDurationFormat;
import org.apache.drill.exec.store.sys.PersistentStore;
import org.apache.drill.exec.store.sys.PersistentStoreProvider;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.exec.work.foreman.Foreman;
import org.apache.drill.shaded.guava.com.google.common.base.Joiner;
import org.apache.drill.shaded.guava.com.google.common.cache.Cache;
import org.apache.drill.shaded.guava.com.google.common.cache.CacheBuilder;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.glassfish.jersey.server.mvc.Viewable;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RolesAllowed(value={"authenticated"})
public class ProfileResources {
    private static final Logger logger = LoggerFactory.getLogger(ProfileResources.class);
    @Inject
    DrillRestServer.UserAuthEnabled authEnabled;
    @Inject
    WorkManager work;
    @Inject
    DrillUserPrincipal principal;
    @Inject
    SecurityContext sc;
    @Inject
    HttpServletRequest request;
    private static final String MAX_QPROFILES_PARAM = "max";
    private static final Cache<String, String> PROFILE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    protected PersistentStoreProvider getProvider() {
        return this.work.getContext().getStoreProvider();
    }

    protected ClusterCoordinator getCoordinator() {
        return this.work.getContext().getClusterCoordinator();
    }

    @GET
    @Path(value="/profiles.json")
    @Produces(value={"application/json"})
    public Response getProfilesJSON(@Context UriInfo uriInfo) {
        QProfilesRunning running_results = (QProfilesRunning)this.getRunningProfilesJSON(uriInfo).getEntity();
        QProfilesCompleted completed_results = (QProfilesCompleted)this.getCompletedProfilesJSON(uriInfo).getEntity();
        ArrayList<String> total_errors = Lists.newArrayList();
        total_errors.addAll(running_results.getErrors());
        total_errors.addAll(completed_results.getErrors());
        QProfiles final_results = new QProfiles(running_results.runningQueries, completed_results.finishedQueries, total_errors);
        return total_errors.size() == 0 ? Response.ok().entity((Object)final_results).build() : Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)final_results).build();
    }

    @GET
    @Path(value="/profiles/json")
    @Produces(value={"application/json"})
    public Response getSpecificJSON(@Context UriInfo uriInfo, @QueryParam(value="status") String status) {
        switch (status) {
            case "running": {
                return this.getRunningProfilesJSON(uriInfo);
            }
            case "completed": {
                return this.getCompletedProfilesJSON(uriInfo);
            }
        }
        return this.getProfilesJSON(uriInfo);
    }

    @GET
    @Path(value="/profiles/running.json")
    @Produces(value={"application/json"})
    public Response getRunningProfilesJSON(@Context UriInfo uriInfo) {
        try {
            QueryProfileStoreContext profileStoreContext = this.work.getContext().getProfileStoreContext();
            TransientStore<UserBitShared.QueryInfo> running = profileStoreContext.getRunningProfileStore();
            ArrayList<String> errors = Lists.newArrayList();
            ArrayList<ProfileInfo> runningQueries = Lists.newArrayList();
            Iterator<Map.Entry<String, UserBitShared.QueryInfo>> runningEntries = running.entries();
            while (runningEntries.hasNext()) {
                try {
                    Map.Entry<String, UserBitShared.QueryInfo> runningEntry = runningEntries.next();
                    UserBitShared.QueryInfo profile = runningEntry.getValue();
                    if (!this.principal.canManageProfileOf(profile.getUser())) continue;
                    runningQueries.add(new ProfileInfo(this.work.getContext().getConfig(), runningEntry.getKey(), profile.getStart(), System.currentTimeMillis(), profile.getForeman().getAddress(), profile.getQuery(), ProfileUtil.getQueryStateDisplayName(profile.getState()), profile.getUser(), profile.getTotalCost(), profile.getQueueName()));
                }
                catch (Exception e) {
                    errors.add(e.getMessage());
                    logger.error("Error getting running query info.", (Throwable)e);
                }
            }
            Collections.sort(runningQueries, Collections.reverseOrder());
            QProfilesRunning rProf = new QProfilesRunning(runningQueries, errors);
            return errors.size() == 0 ? Response.ok().entity((Object)rProf).build() : Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)rProf).build();
        }
        catch (Exception e) {
            throw UserException.resourceError(e).message("Failed to get running profiles from ephemeral store.", new Object[0]).build(logger);
        }
    }

    @GET
    @Path(value="/profiles/completed.json")
    @Produces(value={"application/json"})
    public Response getCompletedProfilesJSON(@Context UriInfo uriInfo) {
        try {
            QueryProfileStoreContext profileStoreContext = this.work.getContext().getProfileStoreContext();
            PersistentStore<UserBitShared.QueryProfile> completed = profileStoreContext.getCompletedProfileStore();
            ArrayList<String> errors = Lists.newArrayList();
            ArrayList<ProfileInfo> finishedQueries = Lists.newArrayList();
            int maxProfilesToLoad = this.work.getContext().getConfig().getInt("drill.exec.http.max_profiles");
            String maxProfilesParams = (String)uriInfo.getQueryParameters().getFirst((Object)MAX_QPROFILES_PARAM);
            if (maxProfilesParams != null && !maxProfilesParams.isEmpty()) {
                maxProfilesToLoad = Integer.valueOf(maxProfilesParams);
            }
            Iterator range = completed.getRange(0, maxProfilesToLoad);
            while (range.hasNext()) {
                try {
                    Map.Entry profileEntry = range.next();
                    UserBitShared.QueryProfile profile = (UserBitShared.QueryProfile)profileEntry.getValue();
                    if (!this.principal.canManageProfileOf(profile.getUser())) continue;
                    finishedQueries.add(new ProfileInfo(this.work.getContext().getConfig(), profileEntry.getKey(), profile.getStart(), profile.getEnd(), profile.getForeman().getAddress(), profile.getQuery(), ProfileUtil.getQueryStateDisplayName(profile.getState()), profile.getUser(), profile.getTotalCost(), profile.getQueueName()));
                }
                catch (Exception e) {
                    errors.add(e.getMessage());
                    logger.error("Error getting finished query profile.", (Throwable)e);
                }
            }
            Collections.sort(finishedQueries, Collections.reverseOrder());
            QProfilesCompleted cProf = new QProfilesCompleted(finishedQueries, errors);
            return errors.size() == 0 ? Response.ok().entity((Object)cProf).build() : Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)cProf).build();
        }
        catch (Exception e) {
            throw UserException.resourceError(e).message("Failed to get completed profiles from persistent store.", new Object[0]).build(logger);
        }
    }

    @GET
    @Path(value="/profiles")
    @Produces(value={"text/html"})
    public Viewable getProfiles(@Context UriInfo uriInfo) {
        QProfiles profiles = (QProfiles)this.getProfilesJSON(uriInfo).getEntity();
        return ViewableWithPermissions.create(this.authEnabled.get(), "/rest/profile/list.ftl", this.sc, profiles);
    }

    private UserBitShared.QueryProfile getQueryProfile(String queryId) {
        UserBitShared.QueryId id = QueryIdHelper.getQueryIdFromString(queryId);
        Foreman f = this.work.getBee().getForemanForQueryId(id);
        if (f != null) {
            UserBitShared.QueryProfile queryProfile = f.getQueryManager().getQueryProfile();
            this.checkOrThrowProfileViewAuthorization(queryProfile);
            return queryProfile;
        }
        try {
            TransientStore<UserBitShared.QueryInfo> running = this.work.getContext().getProfileStoreContext().getRunningProfileStore();
            UserBitShared.QueryInfo info = running.get(queryId);
            if (info != null) {
                UserBitShared.QueryProfile queryProfile = (UserBitShared.QueryProfile)this.work.getContext().getController().getTunnel(info.getForeman()).requestQueryProfile(id).checkedGet(2L, TimeUnit.SECONDS);
                this.checkOrThrowProfileViewAuthorization(queryProfile);
                return queryProfile;
            }
        }
        catch (Exception e) {
            logger.trace("Failed to find query as running profile.", (Throwable)e);
        }
        try {
            PersistentStore<UserBitShared.QueryProfile> profiles = this.work.getContext().getProfileStoreContext().getCompletedProfileStore();
            UserBitShared.QueryProfile queryProfile = profiles.get(queryId);
            if (queryProfile != null) {
                this.checkOrThrowProfileViewAuthorization(queryProfile);
                return queryProfile;
            }
        }
        catch (Exception e) {
            throw new DrillRuntimeException("error while retrieving profile", e);
        }
        throw UserException.validationError().message("No profile with given query id '%s' exists. Please verify the query id.", queryId).build(logger);
    }

    @GET
    @Path(value="/profiles/{queryid}.json")
    @Produces(value={"application/json"})
    public Response getProfileJSON(@PathParam(value="queryid") String queryId) {
        try {
            String profileData = PROFILE_CACHE.getIfPresent(queryId);
            if (profileData == null) {
                profileData = new String(this.work.getContext().getProfileStoreContext().getProfileStoreConfig().getSerializer().serialize(this.getQueryProfile(queryId)));
            } else {
                PROFILE_CACHE.invalidate(queryId);
            }
            return Response.ok().entity((Object)profileData).build();
        }
        catch (Exception e) {
            logger.debug("Failed to serialize profile for: " + queryId);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"{ 'message' : 'error (unable to serialize profile)' }").build();
        }
    }

    @GET
    @Path(value="/profiles/{queryid}")
    @Produces(value={"text/html"})
    public Viewable getProfile(@PathParam(value="queryid") String queryId) {
        try {
            ProfileWrapper wrapper = new ProfileWrapper(this.getQueryProfile(queryId), this.work.getContext().getConfig(), this.request);
            return ViewableWithPermissions.create(this.authEnabled.get(), "/rest/profile/profile.ftl", this.sc, wrapper);
        }
        catch (Error | Exception e) {
            logger.error("Exception was thrown when fetching profile {} :\n{}", (Object)queryId, (Object)e);
            return ViewableWithPermissions.create(this.authEnabled.get(), "/rest/errorMessage.ftl", this.sc, e);
        }
    }

    @POST
    @Path(value="/profiles/view")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    public Viewable viewProfile(@FormDataParam(value="profileData") String content) {
        try {
            UserBitShared.QueryProfile profile = this.work.getContext().getProfileStoreContext().getProfileStoreConfig().getSerializer().deserialize(content.getBytes(StandardCharsets.UTF_8));
            PROFILE_CACHE.put(profile.getQueryId(), content);
            ProfileWrapper wrapper = new ProfileWrapper(profile, this.work.getContext().getConfig(), this.request);
            return ViewableWithPermissions.create(this.authEnabled.get(), "/rest/profile/profile.ftl", this.sc, wrapper);
        }
        catch (Error | Exception e) {
            logger.error("Exception was thrown when parsing profile {} :\n{}", (Object)content, (Object)e);
            return ViewableWithPermissions.create(this.authEnabled.get(), "/rest/errorMessage.ftl", this.sc, e);
        }
    }

    @GET
    @Path(value="/profiles/cancel/{queryid}")
    @Produces(value={"text/plain"})
    public String cancelQuery(@PathParam(value="queryid") String queryId) {
        UserBitShared.QueryId id = QueryIdHelper.getQueryIdFromString(queryId);
        String encodedQueryID = Encode.forHtml((String)queryId);
        if (this.work.getBee().cancelForeman(id, this.principal)) {
            return String.format("Cancelled query %s on locally running node.", encodedQueryID);
        }
        try {
            TransientStore<UserBitShared.QueryInfo> running = this.work.getContext().getProfileStoreContext().getRunningProfileStore();
            UserBitShared.QueryInfo info = running.get(queryId);
            this.checkOrThrowQueryCancelAuthorization(info.getUser(), queryId);
            GeneralRPCProtos.Ack a = (GeneralRPCProtos.Ack)this.work.getContext().getController().getTunnel(info.getForeman()).requestCancelQuery(id).checkedGet(2L, TimeUnit.SECONDS);
            if (a.getOk()) {
                return String.format("Query %s canceled on node %s.", encodedQueryID, info.getForeman().getAddress());
            }
            return String.format("Attempted to cancel query %s on %s but the query is no longer active on that node.", encodedQueryID, info.getForeman().getAddress());
        }
        catch (Exception e) {
            logger.debug("Failure to find query as running profile.", (Throwable)e);
            return String.format("Failure attempting to cancel query %s.  Unable to find information about where query is actively running.", encodedQueryID);
        }
    }

    private void checkOrThrowProfileViewAuthorization(UserBitShared.QueryProfile profile) {
        if (!this.principal.canManageProfileOf(profile.getUser())) {
            throw UserException.permissionError().message("Not authorized to view the profile of query '%s'", profile.getId()).build(logger);
        }
    }

    private void checkOrThrowQueryCancelAuthorization(String queryUser, String queryId) {
        if (!this.principal.canManageQueryOf(queryUser)) {
            throw UserException.permissionError().message("Not authorized to cancel the query '%s'", queryId).build(logger);
        }
    }

    @XmlRootElement
    public class QProfilesRunning
    extends QProfilesBase {
        private final List<ProfileInfo> runningQueries;

        public QProfilesRunning(List<ProfileInfo> runningQueries, List<String> errors) {
            super(errors);
            this.runningQueries = runningQueries;
        }

        public List<ProfileInfo> getRunningQueries() {
            return this.runningQueries;
        }
    }

    @XmlRootElement
    public class QProfilesCompleted
    extends QProfilesBase {
        private final List<ProfileInfo> finishedQueries;

        public QProfilesCompleted(List<ProfileInfo> finishedQueries, List<String> errors) {
            super(errors);
            this.finishedQueries = finishedQueries;
        }

        public List<ProfileInfo> getFinishedQueries() {
            return this.finishedQueries;
        }
    }

    @XmlRootElement
    public class QProfiles
    extends QProfilesBase {
        private final List<ProfileInfo> runningQueries;
        private final List<ProfileInfo> finishedQueries;

        public QProfiles(List<ProfileInfo> runningQueries, List<ProfileInfo> finishedQueries, List<String> errors) {
            super(errors);
            this.runningQueries = runningQueries;
            this.finishedQueries = finishedQueries;
        }

        public List<ProfileInfo> getRunningQueries() {
            return this.runningQueries;
        }

        public List<ProfileInfo> getFinishedQueries() {
            return this.finishedQueries;
        }
    }

    public static class ProfileInfo
    implements Comparable<ProfileInfo> {
        private static final int QUERY_SNIPPET_MAX_CHAR = 150;
        private static final int QUERY_SNIPPET_MAX_LINES = 8;
        public static final SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        private final String queryId;
        private final long startTime;
        private final long endTime;
        private final Date time;
        private final String link;
        private final String foreman;
        private final String query;
        private final String state;
        private final String user;
        private final double totalCost;
        private final String queueName;

        public ProfileInfo(DrillConfig drillConfig, String queryId, long startTime, long endTime, String foreman, String query, String state, String user, double totalCost, String queueName) {
            this.queryId = queryId;
            this.startTime = startTime;
            this.endTime = endTime;
            this.time = new Date(startTime);
            this.foreman = foreman;
            this.link = this.generateLink(drillConfig, foreman, queryId);
            this.query = this.extractQuerySnippet(query);
            this.state = state;
            this.user = user;
            this.totalCost = totalCost;
            this.queueName = queueName;
        }

        public String getUser() {
            return this.user;
        }

        public String getQuery() {
            return this.query;
        }

        public String getQueryId() {
            return this.queryId;
        }

        public String getTime() {
            return format.format(this.time);
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public String getDuration() {
            return new SimpleDurationFormat(this.startTime, this.endTime).verbose();
        }

        public String getState() {
            return this.state;
        }

        public String getLink() {
            return this.link;
        }

        public String getForeman() {
            return this.foreman;
        }

        public double getTotalCost() {
            return this.totalCost;
        }

        public String getQueueName() {
            return this.queueName;
        }

        @Override
        public int compareTo(ProfileInfo other) {
            return this.time.compareTo(other.time);
        }

        private String generateLink(DrillConfig drillConfig, String foreman, String queryId) {
            StringBuilder sb = new StringBuilder();
            if (drillConfig.getBoolean("drill.exec.http.ssl_enabled")) {
                sb.append("https://");
            } else {
                sb.append("http://");
            }
            sb.append(foreman);
            sb.append(":");
            sb.append(drillConfig.getInt("drill.exec.http.port"));
            sb.append("/profiles/");
            sb.append(queryId);
            sb.append(".json");
            return sb.toString();
        }

        private String extractQuerySnippet(String queryText) {
            String sizeCappedQuerySnippet = queryText.substring(0, Math.min(queryText.length(), 150));
            String[] queryParts = sizeCappedQuerySnippet.split(System.lineSeparator());
            if (8 < queryParts.length) {
                int linesConstructed = 0;
                StringBuilder lineCappedQuerySnippet = new StringBuilder();
                for (String qPart : queryParts) {
                    lineCappedQuerySnippet.append(qPart);
                    if (++linesConstructed >= 8) {
                        lineCappedQuerySnippet.append(" ... ");
                        break;
                    }
                    lineCappedQuerySnippet.append(System.lineSeparator());
                }
                return lineCappedQuerySnippet.toString();
            }
            return sizeCappedQuerySnippet;
        }
    }

    @XmlRootElement
    public class QProfilesBase {
        private final List<String> errors;

        public QProfilesBase(List<String> errors) {
            this.errors = errors;
        }

        public List<String> getErrors() {
            return this.errors;
        }

        public int getMaxFetchedQueries() {
            return ProfileResources.this.work.getContext().getConfig().getInt("drill.exec.http.max_profiles");
        }

        public String getQueriesPerPage() {
            List queriesPerPageOptions = ProfileResources.this.work.getContext().getConfig().getIntList("drill.exec.http.profiles_per_page");
            Collections.sort(queriesPerPageOptions);
            return Joiner.on(",").join(queriesPerPageOptions);
        }
    }
}

