/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest.profile;

import java.util.concurrent.TimeUnit;

public class SimpleDurationFormat {
    private long days;
    private long hours;
    private long minutes;
    private long seconds;
    private long milliSeconds;
    private long durationInMillis;

    private SimpleDurationFormat() {
    }

    public SimpleDurationFormat(long startTimeMillis, long endTimeMillis) {
        this.durationInMillis = (startTimeMillis > endTimeMillis ? System.currentTimeMillis() : endTimeMillis) - startTimeMillis;
        this.days = TimeUnit.MILLISECONDS.toDays(this.durationInMillis);
        this.hours = TimeUnit.MILLISECONDS.toHours(this.durationInMillis) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(this.durationInMillis));
        this.minutes = TimeUnit.MILLISECONDS.toMinutes(this.durationInMillis) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(this.durationInMillis));
        this.seconds = TimeUnit.MILLISECONDS.toSeconds(this.durationInMillis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(this.durationInMillis));
        this.milliSeconds = this.durationInMillis - TimeUnit.SECONDS.toMillis(TimeUnit.MILLISECONDS.toSeconds(this.durationInMillis));
    }

    public String compact() {
        if (this.days >= 1L) {
            return this.days + "d" + this.hours + "h" + this.minutes + "m";
        }
        if (this.hours >= 1L) {
            return this.hours + "h" + this.minutes + "m";
        }
        if (this.minutes >= 1L) {
            return this.minutes + "m" + this.seconds + "s";
        }
        return String.format("%.3fs", (double)this.seconds + (double)this.milliSeconds / 1000.0);
    }

    public String verbose() {
        return (this.days > 0L ? this.days + " day " : "") + (this.hours + this.days > 0L ? this.hours + " hr " : "") + (this.minutes + this.hours + this.days > 0L ? String.format("%02d min ", this.minutes) : "") + this.seconds + "." + String.format("%03d sec", this.milliSeconds);
    }
}

