/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest.ssl;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.ssl.SSLConfig;
import org.apache.drill.exec.ssl.SSLConfigBuilder;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslContextFactoryConfigurator {
    private static final Logger logger = LoggerFactory.getLogger(SslContextFactoryConfigurator.class);
    private final DrillConfig config;
    private final String drillbitEndpointAddress;

    public SslContextFactoryConfigurator(DrillConfig config, String drillbitEndpointAddress) {
        this.config = config;
        this.drillbitEndpointAddress = drillbitEndpointAddress;
    }

    public SslContextFactory.Server configureNewSslContextFactory() throws Exception {
        SSLConfig sslConf = new SSLConfigBuilder().config(this.config).mode(SSLConfig.Mode.SERVER).initializeSSLContext(false).validateKeyStore(true).build();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        if (sslConf.isSslValid()) {
            this.useOptionsConfiguredByUser(sslContextFactory, sslConf);
        } else {
            this.useAutoGeneratedSelfSignedCertificate(sslContextFactory);
        }
        return sslContextFactory;
    }

    private void useOptionsConfiguredByUser(SslContextFactory.Server sslFactory, SSLConfig sslConf) {
        logger.info("Using configured SSL settings for web server");
        sslFactory.setKeyStorePath(sslConf.getKeyStorePath());
        sslFactory.setKeyStorePassword(sslConf.getKeyStorePassword());
        sslFactory.setKeyManagerPassword(sslConf.getKeyPassword());
        if (sslConf.hasTrustStorePath()) {
            sslFactory.setTrustStorePath(sslConf.getTrustStorePath());
            if (sslConf.hasTrustStorePassword()) {
                sslFactory.setTrustStorePassword(sslConf.getTrustStorePassword());
            }
        }
        sslFactory.setIncludeProtocols(new String[]{sslConf.getProtocol()});
        if (this.config.hasPath("drill.exec.http.jetty.server.sslContextFactory")) {
            this.setStringIfPresent("drill.exec.http.jetty.server.sslContextFactory.certAlias", arg_0 -> ((SslContextFactory.Server)sslFactory).setCertAlias(arg_0));
            this.setStringIfPresent("drill.exec.http.jetty.server.sslContextFactory.crlPath", arg_0 -> ((SslContextFactory.Server)sslFactory).setCrlPath(arg_0));
            this.setBooleanIfPresent("drill.exec.http.jetty.server.sslContextFactory.enableCRLDP", arg_0 -> ((SslContextFactory.Server)sslFactory).setEnableCRLDP(arg_0));
            this.setBooleanIfPresent("drill.exec.http.jetty.server.sslContextFactory.enableOCSP", arg_0 -> ((SslContextFactory.Server)sslFactory).setEnableOCSP(arg_0));
            this.setStringIfPresent("drill.exec.http.jetty.server.sslContextFactory.endpointIdentificationAlgorithm", arg_0 -> ((SslContextFactory.Server)sslFactory).setEndpointIdentificationAlgorithm(arg_0));
            this.setStringArrayIfPresent("drill.exec.http.jetty.server.sslContextFactory.excludeCipherSuites", arg_0 -> ((SslContextFactory.Server)sslFactory).setExcludeCipherSuites(arg_0));
            this.setStringArrayIfPresent("drill.exec.http.jetty.server.sslContextFactory.excludeProtocols", arg_0 -> ((SslContextFactory.Server)sslFactory).setExcludeProtocols(arg_0));
            this.setStringArrayIfPresent("drill.exec.http.jetty.server.sslContextFactory.includeCipherSuites", arg_0 -> ((SslContextFactory.Server)sslFactory).setIncludeCipherSuites(arg_0));
            this.setStringArrayIfPresent("drill.exec.http.jetty.server.sslContextFactory.includeProtocols", arg_0 -> ((SslContextFactory.Server)sslFactory).setIncludeProtocols(arg_0));
            this.setStringIfPresent("drill.exec.http.jetty.server.sslContextFactory.keyManagerFactoryAlgorithm", arg_0 -> ((SslContextFactory.Server)sslFactory).setKeyManagerFactoryAlgorithm(arg_0));
            this.setStringIfPresent("drill.exec.http.jetty.server.sslContextFactory.keyStoreProvider", arg_0 -> ((SslContextFactory.Server)sslFactory).setKeyStoreProvider(arg_0));
            this.setStringIfPresent("drill.exec.http.jetty.server.sslContextFactory.keyStoreType", arg_0 -> ((SslContextFactory.Server)sslFactory).setKeyStoreType(arg_0));
            this.setIntIfPresent("drill.exec.http.jetty.server.sslContextFactory.maxCertPathLength", arg_0 -> ((SslContextFactory.Server)sslFactory).setMaxCertPathLength(arg_0));
            this.setBooleanIfPresent("drill.exec.http.jetty.server.sslContextFactory.needClientAuth", arg_0 -> ((SslContextFactory.Server)sslFactory).setNeedClientAuth(arg_0));
            this.setStringIfPresent("drill.exec.http.jetty.server.sslContextFactory.ocspResponderURL", arg_0 -> ((SslContextFactory.Server)sslFactory).setOcspResponderURL(arg_0));
            this.setStringIfPresent("drill.exec.http.jetty.server.sslContextFactory.provider", arg_0 -> ((SslContextFactory.Server)sslFactory).setProvider(arg_0));
            this.setBooleanIfPresent("drill.exec.http.jetty.server.sslContextFactory.renegotiationAllowed", arg_0 -> ((SslContextFactory.Server)sslFactory).setRenegotiationAllowed(arg_0));
            this.setIntIfPresent("drill.exec.http.jetty.server.sslContextFactory.renegotiationLimit", arg_0 -> ((SslContextFactory.Server)sslFactory).setRenegotiationLimit(arg_0));
            this.setStringIfPresent("drill.exec.http.jetty.server.sslContextFactory.secureRandomAlgorithm", arg_0 -> ((SslContextFactory.Server)sslFactory).setSecureRandomAlgorithm(arg_0));
            this.setBooleanIfPresent("drill.exec.http.jetty.server.sslContextFactory.sessionCachingEnabled", arg_0 -> ((SslContextFactory.Server)sslFactory).setSessionCachingEnabled(arg_0));
            this.setIntIfPresent("drill.exec.http.jetty.server.sslContextFactory.sslSessionCacheSize", arg_0 -> ((SslContextFactory.Server)sslFactory).setSslSessionCacheSize(arg_0));
            this.setIntIfPresent("drill.exec.http.jetty.server.sslContextFactory.sslSessionTimeout", arg_0 -> ((SslContextFactory.Server)sslFactory).setSslSessionTimeout(arg_0));
            this.setStringIfPresent("drill.exec.http.jetty.server.sslContextFactory.trustManagerFactoryAlgorithm", arg_0 -> ((SslContextFactory.Server)sslFactory).setTrustManagerFactoryAlgorithm(arg_0));
            this.setStringIfPresent("drill.exec.http.jetty.server.sslContextFactory.trustStoreProvider", arg_0 -> ((SslContextFactory.Server)sslFactory).setTrustStoreProvider(arg_0));
            this.setStringIfPresent("drill.exec.http.jetty.server.sslContextFactory.trustStoreType", arg_0 -> ((SslContextFactory.Server)sslFactory).setTrustStoreType(arg_0));
            this.setBooleanIfPresent("drill.exec.http.jetty.server.sslContextFactory.useCipherSuiteOrder", arg_0 -> ((SslContextFactory.Server)sslFactory).setUseCipherSuitesOrder(arg_0));
            this.setBooleanIfPresent("drill.exec.http.jetty.server.sslContextFactory.validateCerts", arg_0 -> ((SslContextFactory.Server)sslFactory).setValidateCerts(arg_0));
            this.setBooleanIfPresent("drill.exec.http.jetty.server.sslContextFactory.validatePeerCerts", arg_0 -> ((SslContextFactory.Server)sslFactory).setValidatePeerCerts(arg_0));
            this.setBooleanIfPresent("drill.exec.http.jetty.server.sslContextFactory.wantClientAuth", arg_0 -> ((SslContextFactory.Server)sslFactory).setWantClientAuth(arg_0));
        }
        logger.info("Web server configured to use TLS protocol '{}'", (Object)String.join((CharSequence)", ", sslFactory.getIncludeProtocols()));
    }

    private void setStringArrayIfPresent(String optKey, Consumer<String[]> optSet) {
        this.setIfPresent(optKey, key -> {
            List list = this.config.getStringList((String)key);
            return list == null ? null : list.toArray(new String[0]);
        }, optSet);
    }

    private void setBooleanIfPresent(String optKey, Consumer<Boolean> optSet) {
        this.setIfPresent(optKey, x$0 -> this.config.getBoolean((String)x$0), optSet);
    }

    private void setStringIfPresent(String optKey, Consumer<String> optSet) {
        this.setIfPresent(optKey, x$0 -> this.config.getString((String)x$0), optSet);
    }

    private void setIntIfPresent(String optKey, Consumer<Integer> optSet) {
        this.setIfPresent(optKey, x$0 -> this.config.getInt((String)x$0), optSet);
    }

    private <T> void setIfPresent(String optKey, Function<String, T> optGet, Consumer<T> optSet) {
        T optVal;
        if (this.config.hasPath(optKey) && (optVal = optGet.apply(optKey)) != null) {
            optSet.accept(optVal);
        }
    }

    private void useAutoGeneratedSelfSignedCertificate(SslContextFactory.Server sslContextFactory) throws Exception {
        logger.info("Using generated self-signed SSL settings for web server");
        SecureRandom random = new SecureRandom();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(1024, random);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X500NameBuilder nameBuilder = new X500NameBuilder(BCStyle.INSTANCE).addRDN(BCStyle.OU, "Apache Drill (auth-generated)").addRDN(BCStyle.O, "Apache Software Foundation (auto-generated)").addRDN(BCStyle.CN, this.drillbitEndpointAddress);
        DateTime now = DateTime.now();
        Date notBefore = now.minusMinutes(1).toDate();
        Date notAfter = now.plusYears(5).toDate();
        BigInteger serialNumber = new BigInteger(128, random);
        JcaX509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(nameBuilder.build(), serialNumber, notBefore, notAfter, nameBuilder.build(), keyPair.getPublic());
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(keyPair.getPrivate());
        X509Certificate certificate = new JcaX509CertificateConverter().getCertificate(certificateBuilder.build(contentSigner));
        certificate.checkValidity(now.toDate());
        certificate.verify(certificate.getPublicKey());
        String keyStorePasswd = RandomStringUtils.random((int)20);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        keyStore.setKeyEntry("DrillAutoGeneratedCert", keyPair.getPrivate(), keyStorePasswd.toCharArray(), new Certificate[]{certificate});
        sslContextFactory.setKeyStore(keyStore);
        sslContextFactory.setKeyStorePassword(keyStorePasswd);
    }
}

