/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest.stream;

import java.io.OutputStream;
import org.apache.calcite.tools.ValidationException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.server.rest.BaseQueryRunner;
import org.apache.drill.exec.server.rest.QueryWrapper;
import org.apache.drill.exec.server.rest.WebUserConnection;
import org.apache.drill.exec.server.rest.stream.StreamingHttpConnection;
import org.apache.drill.exec.work.WorkManager;

public class QueryRunner
extends BaseQueryRunner {
    private StreamingHttpConnection userConn;

    public QueryRunner(WorkManager workManager, WebUserConnection webUserConnection) {
        super(workManager, webUserConnection);
    }

    public void start(QueryWrapper query) throws ValidationException {
        this.applyUserName(query.getUserName());
        this.applyOptions(query.getOptions());
        this.applyDefaultSchema(query.getDefaultSchema());
        this.applyRowLimit(query.getAutoLimitRowCount());
        this.userConn = new StreamingHttpConnection(this.webUserConnection.resources());
        this.startQuery(UserBitShared.QueryType.valueOf(query.getQueryType()), query.getQuery(), this.userConn);
        this.userConn.onStart(this.queryId, this.maxRows);
    }

    public void sendResults(OutputStream output) throws Exception {
        try {
            this.userConn.outputAvailable(output);
            try {
                this.userConn.await();
                this.userConn.finish();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            this.webUserConnection.cleanupSession();
        }
    }
}

