/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.store.RecordReader;
import org.apache.drill.exec.util.Utilities;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecordReader
implements RecordReader {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRecordReader.class);
    protected static final List<SchemaPath> DEFAULT_TEXT_COLS_TO_READ = ImmutableList.of(new SchemaPath(new PathSegment.NameSegment("columns", new PathSegment.ArraySegment(0))));
    private Collection<SchemaPath> columns;
    private boolean isStarQuery;
    private boolean isSkipQuery;

    public String toString() {
        return super.toString() + "[columns = " + this.columns + ", isStarQuery = " + this.isStarQuery + ", isSkipQuery = " + this.isSkipQuery + "]";
    }

    protected final void setColumns(Collection<SchemaPath> projected) {
        Preconditions.checkNotNull(projected, "Columns cannot be null. Use star column to select all fields.");
        this.isSkipQuery = projected.isEmpty();
        Collection<SchemaPath> columnsToRead = projected;
        if (projected.isEmpty()) {
            columnsToRead = this.getDefaultColumnsToRead();
        }
        this.isStarQuery = Utilities.isStarQuery(columnsToRead);
        this.columns = this.transformColumns(columnsToRead);
        logger.debug("columns to read : {}", this.columns);
    }

    protected Collection<SchemaPath> getColumns() {
        return this.columns;
    }

    protected Collection<SchemaPath> transformColumns(Collection<SchemaPath> projected) {
        return projected;
    }

    protected boolean isStarQuery() {
        return this.isStarQuery;
    }

    protected boolean isSkipQuery() {
        return this.isSkipQuery;
    }

    @Override
    public void allocate(Map<String, ValueVector> vectorMap) throws OutOfMemoryException {
        for (ValueVector v : vectorMap.values()) {
            v.allocateNew();
        }
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    protected List<SchemaPath> getDefaultColumnsToRead() {
        return GroupScan.ALL_COLUMNS;
    }
}

