/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import java.io.IOException;
import java.util.List;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.exec.metastore.MetadataProviderManager;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.options.SessionOptionManager;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.dfs.FormatPlugin;

public abstract class AbstractStoragePlugin
implements StoragePlugin {
    protected final DrillbitContext context;
    private final String name;

    protected AbstractStoragePlugin(DrillbitContext inContext, String inName) {
        this.context = inContext;
        this.name = inName == null ? null : inName.toLowerCase();
    }

    @Override
    public boolean supportsRead() {
        return false;
    }

    @Override
    public boolean supportsWrite() {
        return false;
    }

    @Override
    public boolean supportsInsert() {
        return false;
    }

    @Override
    public AbstractGroupScan getPhysicalScan(String userName, JSONOptions selection, SessionOptionManager options) throws IOException {
        return this.getPhysicalScan(userName, selection);
    }

    @Override
    public AbstractGroupScan getPhysicalScan(String userName, JSONOptions selection, SessionOptionManager options, MetadataProviderManager metadataProviderManager) throws IOException {
        return this.getPhysicalScan(userName, selection, options);
    }

    @Override
    public AbstractGroupScan getPhysicalScan(String userName, JSONOptions selection) throws IOException {
        return this.getPhysicalScan(userName, selection, AbstractGroupScan.ALL_COLUMNS);
    }

    @Override
    public AbstractGroupScan getPhysicalScan(String userName, JSONOptions selection, List<SchemaPath> columns, SessionOptionManager options) throws IOException {
        return this.getPhysicalScan(userName, selection, columns);
    }

    @Override
    public AbstractGroupScan getPhysicalScan(String userName, JSONOptions selection, List<SchemaPath> columns, SessionOptionManager options, MetadataProviderManager metadataProviderManager) throws IOException {
        return this.getPhysicalScan(userName, selection, columns, options);
    }

    @Override
    public AbstractGroupScan getPhysicalScan(String userName, JSONOptions selection, List<SchemaPath> columns) throws IOException {
        throw new UnsupportedOperationException("Physical scan is not supported by '" + this.getName() + "' storage plugin.");
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public void onEnabled() throws Exception {
    }

    @Override
    public void onDisabled() throws Exception {
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public FormatPlugin getFormatPlugin(FormatPluginConfig config) {
        throw new UnsupportedOperationException(String.format("%s doesn't support format plugins", this.getClass().getName()));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public DrillbitContext getContext() {
        return this.context;
    }

    public String toString() {
        return this.name;
    }
}

