/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.drill.exec.store.ResourceInputStream;
import org.apache.drill.shaded.guava.com.google.common.io.Resources;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathFileSystem
extends FileSystem {
    static final Logger logger = LoggerFactory.getLogger(ClassPathFileSystem.class);
    static final String ERROR_MSG = "ClassPathFileSystem is read only.";
    private Path working;

    public FSDataOutputStream append(Path arg0, int arg1, Progressable arg2) throws IOException {
        throw new IOException(ERROR_MSG);
    }

    public FSDataOutputStream create(Path arg0, FsPermission arg1, boolean arg2, int arg3, short arg4, long arg5, Progressable arg6) throws IOException {
        throw new IOException(ERROR_MSG);
    }

    public boolean delete(Path arg0) throws IOException {
        throw new IOException(ERROR_MSG);
    }

    public boolean delete(Path arg0, boolean arg1) throws IOException {
        throw new IOException(ERROR_MSG);
    }

    private String getFileName(Path path) {
        String file = path.toUri().getPath();
        if (file.charAt(0) == '/') {
            file = file.substring(1);
        }
        return file;
    }

    public FileStatus getFileStatus(Path arg0) throws IOException {
        URL url;
        String file = this.getFileName(arg0);
        try {
            url = Resources.getResource(file);
        }
        catch (IllegalArgumentException e) {
            throw new FileNotFoundException(String.format("Unable to find path %s.", arg0.toString()));
        }
        return new FileStatus(Resources.asByteSource(url).size(), false, 1, 8096L, System.currentTimeMillis(), arg0);
    }

    public URI getUri() {
        try {
            return new URI("classpath:///");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Path getWorkingDirectory() {
        return this.working;
    }

    public FileStatus[] listStatus(Path arg0) throws IOException {
        throw new UnsupportedOperationException("ClassPathFileSystem doesn't currently support listing files.");
    }

    public boolean mkdirs(Path arg0, FsPermission arg1) throws IOException {
        throw new IOException(ERROR_MSG);
    }

    public FSDataInputStream open(Path arg0, int arg1) throws IOException {
        String file = this.getFileName(arg0);
        URL url = Resources.getResource(file);
        if (url == null) {
            throw new IOException(String.format("Unable to find path %s.", arg0.getName()));
        }
        ResourceInputStream ris = new ResourceInputStream(Resources.toByteArray(url));
        return new FSDataInputStream((InputStream)ris);
    }

    public boolean rename(Path arg0, Path arg1) throws IOException {
        throw new IOException(ERROR_MSG);
    }

    public void setWorkingDirectory(Path arg0) {
        this.working = arg0;
    }
}

