/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.apache.drill.exec.metastore.ColumnNamesOptions;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.util.Utilities;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.io.Files;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ColumnExplorer {
    private final String partitionDesignator;
    private final List<SchemaPath> columns;
    private final boolean isStarQuery;
    private final List<Integer> selectedPartitionColumns;
    private final List<SchemaPath> tableColumns;
    private final Map<String, ImplicitFileColumns> allImplicitColumns;
    private final Map<String, ImplicitInternalFileColumns> allInternalColumns;
    private final Map<String, ImplicitFileColumns> selectedImplicitColumns;
    private final Map<String, ImplicitInternalFileColumns> selectedInternalColumns;

    public ColumnExplorer(OptionManager optionManager, List<SchemaPath> columns) {
        this.partitionDesignator = optionManager.getString("drill.exec.storage.file.partition.column.label");
        this.selectedPartitionColumns = Lists.newArrayList();
        this.tableColumns = Lists.newArrayList();
        this.allImplicitColumns = ColumnExplorer.initImplicitFileColumns(optionManager);
        this.allInternalColumns = ColumnExplorer.initImplicitInternalFileColumns(optionManager);
        this.selectedImplicitColumns = CaseInsensitiveMap.newHashMap();
        this.selectedInternalColumns = CaseInsensitiveMap.newHashMap();
        if (columns == null) {
            this.isStarQuery = false;
            this.columns = null;
        } else {
            this.columns = columns;
            this.isStarQuery = Utilities.isStarQuery(columns);
            this.init();
        }
    }

    public ColumnExplorer(OptionManager optionManager) {
        this(optionManager, null);
    }

    public static Map<String, ImplicitFileColumns> initImplicitFileColumns(OptionManager optionManager) {
        CaseInsensitiveMap<ImplicitFileColumns> map = CaseInsensitiveMap.newHashMap();
        for (ImplicitFileColumns e : ImplicitFileColumns.values()) {
            OptionValue optionValue = optionManager.getOption(e.optionName);
            if (optionValue == null) continue;
            map.put(optionValue.string_val, e);
        }
        return map;
    }

    public static Map<String, ImplicitInternalFileColumns> initImplicitInternalFileColumns(OptionManager optionManager) {
        CaseInsensitiveMap<ImplicitInternalFileColumns> map = CaseInsensitiveMap.newHashMap();
        for (ImplicitInternalFileColumns e : ImplicitInternalFileColumns.values()) {
            OptionValue optionValue = optionManager.getOption(e.name);
            if (optionValue == null) continue;
            map.put(optionValue.string_val, e);
        }
        return map;
    }

    public static List<String> getImplicitColumnsNames(SchemaConfig schemaConfig) {
        ArrayList<String> implicitColumns = Lists.newArrayList();
        for (ImplicitFileColumns e : ImplicitFileColumns.values()) {
            OptionValue optionValue = schemaConfig.getOption(e.optionName);
            if (optionValue == null) continue;
            implicitColumns.add(optionValue.string_val);
        }
        return implicitColumns;
    }

    public static boolean isPartitionColumn(OptionManager optionManager, SchemaPath column) {
        String partitionDesignator = optionManager.getString("drill.exec.storage.file.partition.column.label");
        String path = column.getRootSegmentPath();
        return ColumnExplorer.isPartitionColumn(partitionDesignator, path);
    }

    public static boolean isPartitionColumn(String partitionDesignator, String path) {
        Pattern pattern = Pattern.compile(String.format("%s[0-9]+", partitionDesignator));
        Matcher matcher = pattern.matcher(path);
        return matcher.matches();
    }

    public boolean isImplicitOrInternalFileColumn(String name) {
        return this.allImplicitColumns.get(name) != null || this.allInternalColumns.get(name) != null;
    }

    public static List<String> getPartitionColumnNames(FileSelection selection, ColumnNamesOptions columnNamesOptions) {
        String partitionColumnLabel = columnNamesOptions.partitionColumnNameLabel();
        return ColumnExplorer.getPartitionColumnNames(selection, partitionColumnLabel);
    }

    private static List<String> getPartitionColumnNames(FileSelection selection, String partitionColumnLabel) {
        int partitionsCount = ColumnExplorer.getPartitionDepth(selection);
        ArrayList<String> partitions = new ArrayList<String>();
        for (int i = 0; i < partitionsCount; ++i) {
            partitions.add(partitionColumnLabel + i);
        }
        return partitions;
    }

    public static int getPartitionDepth(FileSelection selection) {
        int rootDepth = selection.getSelectionRoot().depth();
        int partitionsCount = 0;
        for (Path file : selection.getFiles()) {
            int currentPartitionsCount = file.depth() - rootDepth - 1;
            partitionsCount = Math.max(partitionsCount, currentPartitionsCount);
        }
        return partitionsCount;
    }

    public Map<String, String> populateImplicitColumns(Path filePath, List<String> partitionValues, boolean includeFileImplicitColumns) {
        LinkedHashMap<String, String> implicitValues = new LinkedHashMap<String, String>();
        for (int i = 0; i < partitionValues.size(); ++i) {
            if (!this.isStarQuery && !this.selectedPartitionColumns.contains(i)) continue;
            implicitValues.put(this.partitionDesignator + i, partitionValues.get(i));
        }
        if (includeFileImplicitColumns) {
            Path path = Path.getPathWithoutSchemeAndAuthority((Path)filePath);
            for (Map.Entry<String, ImplicitFileColumns> entry : this.selectedImplicitColumns.entrySet()) {
                implicitValues.put(entry.getKey(), entry.getValue().getValue(path));
            }
        }
        return implicitValues;
    }

    public Map<String, String> populateColumns(Path filePath, List<String> partitionValues, boolean includeFileImplicitColumns, FileSystem fs) {
        LinkedHashMap<String, String> implicitValues = new LinkedHashMap<String, String>(this.populateImplicitColumns(filePath, partitionValues, includeFileImplicitColumns));
        this.selectedInternalColumns.forEach((key, value) -> implicitValues.put((String)key, ColumnExplorer.getImplicitColumnValue(value, filePath, fs)));
        return implicitValues;
    }

    public Map<String, String> populateColumns(Path filePath, List<String> partitionValues, boolean includeFileImplicitColumns, FileSystem fs, int index, long start, long length) {
        LinkedHashMap<String, String> implicitValues = new LinkedHashMap<String, String>(this.populateColumns(filePath, partitionValues, includeFileImplicitColumns, fs));
        this.selectedInternalColumns.forEach((key, value) -> implicitValues.put((String)key, ColumnExplorer.getImplicitColumnValue(value, filePath, fs, index, start, length)));
        return implicitValues;
    }

    public static String getImplicitColumnValue(ImplicitFileColumn column, Path filePath, FileSystem fs, Integer index, Long start, Long length) {
        if (column instanceof ImplicitFileColumns) {
            ImplicitFileColumns fileColumn = (ImplicitFileColumns)column;
            return fileColumn.getValue(filePath);
        }
        if (column instanceof ImplicitInternalFileColumns) {
            ImplicitInternalFileColumns fileColumn = (ImplicitInternalFileColumns)column;
            switch (fileColumn) {
                case ROW_GROUP_INDEX: {
                    return index != null ? String.valueOf(index) : null;
                }
                case ROW_GROUP_START: {
                    return start != null ? String.valueOf(start) : null;
                }
                case ROW_GROUP_LENGTH: {
                    return length != null ? String.valueOf(length) : null;
                }
                case PROJECT_METADATA: {
                    return Boolean.FALSE.toString();
                }
                case USE_METADATA: {
                    return null;
                }
                case LAST_MODIFIED_TIME: {
                    try {
                        return fs != null ? String.valueOf(fs.getFileStatus(filePath).getModificationTime()) : null;
                    }
                    catch (IOException e) {
                        throw new DrillRuntimeException(e);
                    }
                }
            }
        }
        return null;
    }

    public static String getImplicitColumnValue(ImplicitFileColumn column, Path filePath, FileSystem fs) {
        return ColumnExplorer.getImplicitColumnValue(column, filePath, fs, null, null, null);
    }

    public static List<ImplicitFileColumn> getImplicitFileColumns() {
        ArrayList<ImplicitFileColumn> implicitColumns = new ArrayList<ImplicitFileColumn>();
        Collections.addAll(implicitColumns, ImplicitFileColumns.values());
        implicitColumns.add(ImplicitInternalFileColumns.LAST_MODIFIED_TIME);
        implicitColumns.add(ImplicitInternalFileColumns.USE_METADATA);
        return implicitColumns;
    }

    public static List<String> listPartitionValues(Path file, Path root, boolean hasDirsOnly) {
        String[] dirs = ColumnExplorer.parsePartitions(file, root, hasDirsOnly);
        if (dirs == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(dirs);
    }

    public static String[] parsePartitions(Path file, Path root, boolean hasDirsOnly) {
        if (file == null || root == null) {
            return null;
        }
        if (!hasDirsOnly) {
            file = file.getParent();
        }
        int rootDepth = root.depth();
        int fileDepth = file.depth();
        int diffCount = fileDepth - rootDepth;
        if (diffCount < 0) {
            return null;
        }
        String[] diffDirectoryNames = new String[diffCount];
        for (int i = rootDepth; fileDepth > i; ++i) {
            diffDirectoryNames[fileDepth - i - 1] = file.getName();
            file = file.getParent();
        }
        return diffDirectoryNames;
    }

    public boolean isStarQuery() {
        return this.isStarQuery;
    }

    public List<SchemaPath> getTableColumns() {
        return this.tableColumns;
    }

    public boolean containsPartitionColumns() {
        return !this.selectedPartitionColumns.isEmpty();
    }

    public boolean containsImplicitColumns() {
        return !this.selectedImplicitColumns.isEmpty();
    }

    private void init() {
        for (SchemaPath column : this.columns) {
            String path = column.getRootSegmentPath();
            if (this.isStarQuery) {
                if (this.allImplicitColumns.get(path) != null) {
                    this.selectedImplicitColumns.put(path, this.allImplicitColumns.get(path));
                    continue;
                }
                if (this.allInternalColumns.get(path) == null) continue;
                this.selectedInternalColumns.put(path, this.allInternalColumns.get(path));
                continue;
            }
            if (ColumnExplorer.isPartitionColumn(this.partitionDesignator, path)) {
                this.selectedPartitionColumns.add(Integer.parseInt(path.substring(this.partitionDesignator.length())));
                continue;
            }
            if (this.allImplicitColumns.get(path) != null) {
                this.selectedImplicitColumns.put(path, this.allImplicitColumns.get(path));
                continue;
            }
            if (this.allInternalColumns.get(path) != null) {
                this.selectedInternalColumns.put(path, this.allInternalColumns.get(path));
                continue;
            }
            this.tableColumns.add(column);
        }
    }

    public static enum ImplicitFileColumns implements ImplicitFileColumn
    {
        FQN("drill.exec.storage.implicit.fqn.column.label", "fqn"){

            @Override
            public String getValue(Path path) {
                return path.toUri().getPath();
            }
        }
        ,
        FILEPATH("drill.exec.storage.implicit.filepath.column.label", "filepath"){

            @Override
            public String getValue(Path path) {
                return path.getParent().toUri().getPath();
            }
        }
        ,
        FILENAME("drill.exec.storage.implicit.filename.column.label", "filename"){

            @Override
            public String getValue(Path path) {
                return path.getName();
            }
        }
        ,
        SUFFIX("drill.exec.storage.implicit.suffix.column.label", "suffix"){

            @Override
            public String getValue(Path path) {
                return Files.getFileExtension(path.getName());
            }
        };

        String optionName;
        String propValue;

        private ImplicitFileColumns(String optionName, String propValue) {
            this.optionName = optionName;
            this.propValue = propValue;
        }

        @Override
        public String optionName() {
            return this.optionName;
        }

        public String propertyValue() {
            return this.propValue;
        }

        public abstract String getValue(Path var1);
    }

    public static enum ImplicitInternalFileColumns implements ImplicitFileColumn
    {
        LAST_MODIFIED_TIME("drill.exec.storage.implicit.last_modified_time.column.label"),
        ROW_GROUP_INDEX("drill.exec.storage.implicit.row_group_index.column.label"),
        ROW_GROUP_START("drill.exec.storage.implicit.row_group_start.column.label"),
        ROW_GROUP_LENGTH("drill.exec.storage.implicit.row_group_length.column.label"),
        USE_METADATA("drill.exec.storage.implicit.project_metadata.column.label"){

            @Override
            public boolean isOptional() {
                return true;
            }
        }
        ,
        PROJECT_METADATA("drill.exec.storage.implicit.project_metadata.column.label"){

            @Override
            public boolean isOptional() {
                return true;
            }
        };

        private final String name;

        private ImplicitInternalFileColumns(String name) {
            this.name = name;
        }

        @Override
        public String optionName() {
            return this.name;
        }
    }

    public static interface ImplicitFileColumn {
        public String optionName();

        default public boolean isOptional() {
            return false;
        }
    }
}

