/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.MetricDef;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.parquet.ParquetReaderStats;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.slf4j.Logger;

public abstract class CommonParquetRecordReader
extends AbstractRecordReader {
    public static final int NUM_RECORDS_TO_READ_NOT_SPECIFIED = -1;
    protected final FragmentContext fragmentContext;
    public ParquetReaderStats parquetReaderStats = new ParquetReaderStats();
    protected OperatorContext operatorContext;
    protected ParquetMetadata footer;

    public CommonParquetRecordReader(ParquetMetadata footer, FragmentContext fragmentContext) {
        this.footer = footer;
        this.fragmentContext = fragmentContext;
    }

    public void updateRowGroupsStats(long numRowGroups, long rowGroupsPruned) {
        this.parquetReaderStats.numRowgroups.set(numRowGroups);
        this.parquetReaderStats.rowgroupsPruned.set(rowGroupsPruned);
    }

    protected void closeStats(Logger logger, Path hadoopPath) {
        if (this.parquetReaderStats != null) {
            if (this.operatorContext != null) {
                this.parquetReaderStats.update(this.operatorContext.getStats());
            }
            this.parquetReaderStats.logStats(logger, hadoopPath);
            this.parquetReaderStats = null;
        }
    }

    protected int initNumRecordsToRead(long numRecordsToRead, int rowGroupIndex, ParquetMetadata footer) {
        if (numRecordsToRead == 0L) {
            return 0;
        }
        int numRowsInRowGroup = (int)((BlockMetaData)footer.getBlocks().get(rowGroupIndex)).getRowCount();
        return numRecordsToRead == -1L ? numRowsInRowGroup : (int)Math.min(numRecordsToRead, (long)numRowsInRowGroup);
    }

    protected RuntimeException handleAndRaise(String message, Exception e) {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String errorMessage = "Error in drill parquet reader (complex).\nMessage: " + message + "\nParquet Metadata: " + this.footer;
        return new DrillRuntimeException(errorMessage, e);
    }

    public static enum Metric implements MetricDef
    {
        NUM_ROWGROUPS,
        ROWGROUPS_PRUNED,
        NUM_DICT_PAGE_LOADS,
        NUM_DATA_PAGE_lOADS,
        NUM_DATA_PAGES_DECODED,
        NUM_DICT_PAGES_DECOMPRESSED,
        NUM_DATA_PAGES_DECOMPRESSED,
        TOTAL_DICT_PAGE_READ_BYTES,
        TOTAL_DATA_PAGE_READ_BYTES,
        TOTAL_DICT_DECOMPRESSED_BYTES,
        TOTAL_DATA_DECOMPRESSED_BYTES,
        TIME_DICT_PAGE_LOADS,
        TIME_DATA_PAGE_LOADS,
        TIME_DATA_PAGE_DECODE,
        TIME_DICT_PAGE_DECODE,
        TIME_DICT_PAGES_DECOMPRESSED,
        TIME_DATA_PAGES_DECOMPRESSED,
        TIME_DISK_SCAN_WAIT,
        TIME_DISK_SCAN,
        TIME_FIXEDCOLUMN_READ,
        TIME_VARCOLUMN_READ,
        TIME_PROCESS;


        @Override
        public int metricId() {
            return this.ordinal();
        }
    }
}

