/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.store.ConnectorLocator;
import org.apache.drill.exec.store.PluginHandle;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorHandle {
    private static final Logger logger = LoggerFactory.getLogger(ConnectorHandle.class);
    private final ConnectorLocator locator;
    private final Class<? extends StoragePluginConfig> configClass;
    private final boolean isIntrinsic;

    private ConnectorHandle(ConnectorLocator locator, Class<? extends StoragePluginConfig> configClass) {
        this.locator = locator;
        this.configClass = configClass;
        this.isIntrinsic = false;
    }

    private ConnectorHandle(ConnectorLocator locator, StoragePlugin plugin) {
        this.locator = locator;
        this.configClass = plugin.getConfig().getClass();
        this.isIntrinsic = true;
    }

    public static ConnectorHandle configuredConnector(ConnectorLocator locator, Class<? extends StoragePluginConfig> configClass) {
        return new ConnectorHandle(locator, configClass);
    }

    public static ConnectorHandle intrinsicConnector(ConnectorLocator locator, StoragePlugin plugin) {
        return new ConnectorHandle(locator, plugin);
    }

    public boolean isIntrinsic() {
        return this.isIntrinsic;
    }

    public boolean isStored() {
        return !this.isIntrinsic() && this.locator.storable();
    }

    public ConnectorLocator locator() {
        return this.locator;
    }

    public Class<? extends StoragePluginConfig> configClass() {
        return this.configClass;
    }

    public Class<? extends StoragePlugin> connectorClass() {
        return this.locator.connectorClassFor(this.configClass);
    }

    public PluginHandle pluginEntryFor(String name, StoragePluginConfig config, PluginHandle.PluginType type) {
        Preconditions.checkArgument(this.configClass.isInstance(config));
        Preconditions.checkArgument(type != PluginHandle.PluginType.INTRINSIC || this.isIntrinsic());
        return new PluginHandle(name, config, this, type);
    }

    public StoragePlugin newInstance(String name, StoragePluginConfig config) throws Exception {
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(config);
        Preconditions.checkArgument(this.configClass.isInstance(config));
        return this.locator.create(name, config);
    }
}

