/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jasonclawson.jackson.dataformat.hocon.HoconFactory;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.config.LogicalPlanPersistence;
import org.apache.drill.common.scanner.persistence.ScanResult;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.PluginRegistryContext;

public class DrillbitPluginRegistryContext
implements PluginRegistryContext {
    private final DrillbitContext drillbitContext;
    private final ObjectMapper mapper;
    private final ObjectMapper hoconMapper;

    public DrillbitPluginRegistryContext(DrillbitContext drillbitContext) {
        this.drillbitContext = drillbitContext;
        this.mapper = drillbitContext.getLpPersistence().getMapper();
        LogicalPlanPersistence persistence = new LogicalPlanPersistence(drillbitContext.getConfig(), drillbitContext.getClasspathScan(), JacksonUtils.createObjectMapper((JsonFactory)new HoconFactory()));
        this.hoconMapper = persistence.getMapper();
    }

    @Override
    public DrillConfig config() {
        return this.drillbitContext.getConfig();
    }

    @Override
    public ObjectMapper mapper() {
        return this.mapper;
    }

    @Override
    public ObjectMapper hoconMapper() {
        return this.hoconMapper;
    }

    @Override
    public ScanResult classpathScan() {
        return this.drillbitContext.getClasspathScan();
    }

    @Override
    public DrillbitContext drillbitContext() {
        return this.drillbitContext;
    }
}

