/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.apache.commons.io.FileUtils;
import org.apache.drill.common.exceptions.UserException;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSyncableFileSystem
extends FileSystem {
    private static final Logger logger = LoggerFactory.getLogger(LocalSyncableFileSystem.class);

    public URI getUri() {
        try {
            return new URI("drill-local:///");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public FSDataInputStream open(Path path, int i) throws IOException {
        return new FSDataInputStream((InputStream)new LocalInputStream(path));
    }

    public FSDataOutputStream create(Path path, FsPermission fsPermission, boolean b, int i, short i2, long l, Progressable progressable) throws IOException {
        return new FSDataOutputStream((OutputStream)new LocalSyncableOutputStream(path), FileSystem.getStatistics((String)path.toUri().getScheme(), ((Object)((Object)this)).getClass()));
    }

    public FSDataOutputStream append(Path path, int i, Progressable progressable) throws IOException {
        throw new IOException("Append is not supported in LocalSyncableFilesystem");
    }

    public boolean rename(Path path, Path path2) throws IOException {
        throw new IOException("Rename not supported");
    }

    public boolean delete(Path path) throws IOException {
        File file = new File(path.toString());
        return file.delete();
    }

    public boolean delete(Path path, boolean b) throws IOException {
        File file = new File(path.toString());
        if (b) {
            if (file.isDirectory()) {
                FileUtils.deleteDirectory((File)file);
            } else {
                file.delete();
            }
        } else if (file.isDirectory()) {
            throw new IOException("Cannot delete directory");
        }
        file.delete();
        return true;
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        throw new IOException("listStatus not supported");
    }

    public void setWorkingDirectory(Path path) {
    }

    public Path getWorkingDirectory() {
        return null;
    }

    public boolean mkdirs(Path path, FsPermission fsPermission) throws IOException {
        return new File(path.toString()).mkdirs();
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        File file = new File(Path.getPathWithoutSchemeAndAuthority((Path)path).toString());
        return new FileStatus(file.length(), file.isDirectory(), 1, 0L, file.lastModified(), path);
    }

    public class LocalInputStream
    extends InputStream
    implements Seekable,
    PositionedReadable,
    ByteBufferReadable {
        private BufferedInputStream input;
        private final String path;
        private long position;

        public LocalInputStream(Path path) throws IOException {
            this.path = path.toString();
            this.input = new BufferedInputStream(new FileInputStream(new RandomAccessFile(this.path, "r").getFD()), 0x100000);
        }

        public int read(long l, byte[] bytes, int i, int i2) throws IOException {
            throw new IOException("unsupported operation");
        }

        public void readFully(long l, byte[] bytes, int i, int i2) throws IOException {
            throw new IOException("unsupported operation");
        }

        public void readFully(long l, byte[] bytes) throws IOException {
            throw new IOException("unsupported operation");
        }

        public void seek(long l) throws IOException {
            this.input.close();
            RandomAccessFile raf = new RandomAccessFile(this.path, "r");
            raf.seek(l);
            this.input = new BufferedInputStream(new FileInputStream(raf.getFD()), 0x100000);
            this.position = l;
        }

        public long getPos() throws IOException {
            return this.position;
        }

        public boolean seekToNewSource(long l) throws IOException {
            throw new IOException("seekToNewSource not supported");
        }

        public int read(ByteBuffer buf) throws IOException {
            buf.reset();
            if (buf.hasArray()) {
                int read = this.read(buf.array(), buf.arrayOffset(), buf.capacity());
                buf.limit(read);
                return read;
            }
            byte[] b = new byte[buf.capacity()];
            int read = this.read(b);
            buf.put(b);
            return read;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.input.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.input.read(b, off, len);
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            this.input.read(b);
            ++this.position;
            return b[0] & 0xFF;
        }

        @Override
        public void close() {
            try {
                this.input.close();
            }
            catch (IOException e) {
                throw UserException.dataWriteError(e).addContext("Failed to close local syncable file system %s, possible data loss.", this.path).build(logger);
            }
        }
    }

    public class LocalSyncableOutputStream
    extends OutputStream
    implements Syncable {
        private final FileOutputStream fos;
        private final BufferedOutputStream output;

        public LocalSyncableOutputStream(Path path) throws FileNotFoundException {
            boolean success;
            File dir = new File(path.getParent().toString());
            if (!dir.exists() && !(success = dir.mkdirs())) {
                throw new FileNotFoundException("failed to create parent directory");
            }
            this.fos = new FileOutputStream(new File(path.toString()));
            this.output = new BufferedOutputStream(this.fos, 65536);
        }

        public void sync() throws IOException {
            this.hflush();
        }

        public void hsync() throws IOException {
            this.output.flush();
            this.fos.getFD().sync();
        }

        public void hflush() throws IOException {
            this.hsync();
        }

        @Override
        public void write(int b) throws IOException {
            this.output.write(b);
        }
    }
}

