/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.scanner.ClassPathScanner;
import org.apache.drill.exec.planner.logical.StoragePlugins;
import org.apache.drill.exec.store.PluginBootstrapLoader;
import org.apache.drill.exec.store.PluginRegistryContext;
import org.apache.drill.exec.store.dfs.FileSystemConfig;
import org.apache.drill.exec.util.ActionOnFile;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.apache.drill.shaded.guava.com.google.common.io.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginBootstrapLoaderImpl
implements PluginBootstrapLoader {
    private static final Logger logger = LoggerFactory.getLogger(PluginBootstrapLoaderImpl.class);
    private final PluginRegistryContext context;
    private URL pluginsOverrideFileUrl;

    public PluginBootstrapLoaderImpl(PluginRegistryContext context) {
        this.context = context;
    }

    @Override
    public StoragePlugins bootstrapPlugins() throws IOException {
        HashMap<String, URL> pluginURLMap = new HashMap<String, URL>();
        StoragePlugins bootstrapPlugins = this.loadBootstrapPlugins(pluginURLMap);
        StoragePlugins updatedPlugins = this.updatedPlugins();
        if (updatedPlugins != null) {
            bootstrapPlugins.putAll(updatedPlugins);
        }
        this.applyFormatPlugins(bootstrapPlugins, pluginURLMap);
        return bootstrapPlugins;
    }

    @VisibleForTesting
    protected StoragePlugins loadBootstrapPlugins(Map<String, URL> pluginURLMap) throws IOException {
        String storageBootstrapFileName = this.context.config().getString("drill.exec.storage.bootstrap.storage");
        Set<URL> storageUrls = ClassPathScanner.forResource(storageBootstrapFileName, false);
        if (storageUrls == null || storageUrls.isEmpty()) {
            throw new IOException("Cannot find storage plugin boostrap file: " + storageBootstrapFileName);
        }
        logger.info("Loading the storage plugin configs from URLs {}.", storageUrls);
        StoragePlugins bootstrapPlugins = new StoragePlugins();
        for (URL url : storageUrls) {
            try {
                this.loadStoragePlugins(url, bootstrapPlugins, pluginURLMap);
            }
            catch (IOException e) {
                throw new IOException("Failed to load bootstrap plugins from " + url.toString(), e);
            }
        }
        return bootstrapPlugins;
    }

    private void applyFormatPlugins(StoragePlugins bootstrapPlugins, Map<String, URL> pluginURLMap) throws IOException {
        String formatBootstrapFileName = this.context.config().getString("drill.exec.storage.bootstrap.format");
        Set<URL> formatUrls = ClassPathScanner.forResource(formatBootstrapFileName, false);
        if (formatUrls == null) {
            return;
        }
        for (URL url : formatUrls) {
            logger.info("Loading format plugin configs from {}.", (Object)url);
            this.loadFormatPlugins(url, bootstrapPlugins, pluginURLMap);
        }
    }

    @Override
    public StoragePlugins updatedPlugins() {
        StoragePlugins storagePlugins;
        block10: {
            String upgradeFileName = this.context.config().getString("drill.exec.storage.upgrade.storage");
            Set<URL> urlSet = ClassPathScanner.forResource(upgradeFileName, false);
            if (urlSet.isEmpty()) {
                logger.trace("The {} file is absent. Proceed without updating of the storage plugins configs", (Object)upgradeFileName);
                return null;
            }
            if (urlSet.size() != 1) {
                throw DrillRuntimeException.create("More than one %s file is placed in Drill's classpath: %s", upgradeFileName, urlSet);
            }
            this.pluginsOverrideFileUrl = urlSet.iterator().next();
            InputStream is = this.pluginsOverrideFileUrl.openStream();
            try {
                storagePlugins = (StoragePlugins)this.context.hoconMapper().readValue(is, StoragePlugins.class);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("Failures are obtained while loading file: '{}'. Proceeding without update.", (Object)upgradeFileName, (Object)e);
                    return null;
                }
            }
            is.close();
        }
        return storagePlugins;
    }

    @Override
    public void onUpgrade() {
        if (this.pluginsOverrideFileUrl == null) {
            return;
        }
        String fileAction = this.context.config().getString("drill.exec.storage.action_on_plugins_override_file");
        Optional<ActionOnFile> actionOnFile = Arrays.stream(ActionOnFile.values()).filter(action -> action.name().equalsIgnoreCase(fileAction)).findFirst();
        actionOnFile.ifPresent(action -> action.action(this.pluginsOverrideFileUrl));
        if (!actionOnFile.isPresent()) {
            logger.warn("Unknown value {} for {} boot option. Nothing will be done with file.", (Object)fileAction, (Object)"drill.exec.storage.action_on_plugins_override_file");
        }
    }

    private void loadStoragePlugins(URL url, StoragePlugins bootstrapPlugins, Map<String, URL> pluginURLMap) throws IOException {
        StoragePlugins plugins = this.getPluginsFromResource(url);
        plugins.forEach(plugin -> {
            StoragePluginConfig oldPluginConfig = bootstrapPlugins.putIfAbsent((String)plugin.getKey(), (StoragePluginConfig)plugin.getValue());
            if (oldPluginConfig != null) {
                logger.warn("Duplicate plugin instance '[{}]' defined in [{}, {}], ignoring the later one.", new Object[]{plugin.getKey(), pluginURLMap.get(plugin.getKey()), url});
            } else {
                pluginURLMap.put((String)plugin.getKey(), url);
            }
        });
    }

    private void loadFormatPlugins(URL url, StoragePlugins bootstrapPlugins, Map<String, URL> pluginURLMap) throws IOException {
        StoragePlugins plugins = this.getPluginsFromResource(url);
        for (Map.Entry<String, StoragePluginConfig> sourceEntry : plugins) {
            String pluginName = sourceEntry.getKey();
            StoragePluginConfig sourcePlugin = sourceEntry.getValue();
            if (!(sourcePlugin instanceof FileSystemConfig)) {
                logger.warn("Formats are only supported by File System plugins. Source name '{}' is of type '{}'.", (Object)pluginName, (Object)sourcePlugin.getClass().getName());
                continue;
            }
            StoragePluginConfig targetPlugin = bootstrapPlugins.getConfig(pluginName);
            if (targetPlugin == null) {
                logger.warn("No boostrap storage plugin matches the name '{}'", (Object)pluginName);
                continue;
            }
            if (!(targetPlugin instanceof FileSystemConfig)) {
                logger.warn("Formats are only supported by File System plugins. Source name '{}' is of type '{}' but the bootstrap plugin of that name is of type '{}.", new Object[]{pluginName, sourcePlugin.getClass().getName(), targetPlugin.getClass().getName()});
                continue;
            }
            FileSystemConfig targetFsConfig = (FileSystemConfig)targetPlugin;
            FileSystemConfig sourceFsConfig = (FileSystemConfig)sourcePlugin;
            sourceFsConfig.getFormats().forEach((formatName, formatValue) -> {
                FormatPluginConfig oldPluginConfig = targetFsConfig.getFormats().putIfAbsent((String)formatName, (FormatPluginConfig)formatValue);
                if (oldPluginConfig != null) {
                    logger.warn("Duplicate format instance '{}' defined in '{}' and '{}', ignoring the later one.", new Object[]{formatName, pluginURLMap.get(pluginName), url});
                }
            });
        }
    }

    private StoragePlugins getPluginsFromResource(URL resource) throws IOException {
        String pluginsData = Resources.toString(resource, Charsets.UTF_8);
        return (StoragePlugins)this.context.hoconMapper().readValue(pluginsData, StoragePlugins.class);
    }
}

