/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.store.ConnectorHandle;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginHandle {
    private static final Logger logger = LoggerFactory.getLogger(PluginHandle.class);
    private final String name;
    private final StoragePluginConfig config;
    private final ConnectorHandle connector;
    private final PluginType type;
    private StoragePlugin plugin;

    public PluginHandle(String name, StoragePluginConfig config, ConnectorHandle connector) {
        this.name = name;
        this.config = config;
        this.connector = connector;
        this.type = connector.isIntrinsic() ? PluginType.INTRINSIC : PluginType.STORED;
    }

    public PluginHandle(String name, StoragePluginConfig config, ConnectorHandle connector, PluginType type) {
        this.name = name;
        this.config = config;
        this.connector = connector;
        this.type = type;
    }

    public PluginHandle(StoragePlugin plugin, ConnectorHandle connector, PluginType type) {
        this.name = plugin.getName();
        this.config = plugin.getConfig();
        this.connector = connector;
        this.plugin = plugin;
        this.type = type;
    }

    public String name() {
        return this.name;
    }

    public StoragePluginConfig config() {
        return this.config;
    }

    public boolean isStored() {
        return this.type == PluginType.STORED;
    }

    public boolean isIntrinsic() {
        return this.type == PluginType.INTRINSIC;
    }

    public synchronized StoragePlugin plugin() {
        if (this.plugin != null) {
            return this.plugin;
        }
        logger.info("Creating storage plugin for {}", (Object)this.name);
        try {
            this.plugin = this.connector.newInstance(this.name, this.config);
        }
        catch (UserException e) {
            throw e;
        }
        catch (Exception e) {
            throw UserException.internalError(e).addContext("Plugin name", this.name).addContext("Plugin class", this.connector.connectorClass().getName()).build(logger);
        }
        try {
            this.plugin.start();
        }
        catch (UserException e) {
            this.plugin = null;
            throw e;
        }
        catch (Exception e) {
            this.plugin = null;
            throw UserException.dataReadError(e).addContext("Failed to start storage plugin").addContext("Plugin name", this.name).addContext("Plugin class", this.connector.connectorClass().getName()).build(logger);
        }
        return this.plugin;
    }

    @VisibleForTesting
    public synchronized boolean hasInstance() {
        return this.plugin != null;
    }

    public synchronized void close() {
        try {
            if (this.plugin != null) {
                this.plugin.close();
            }
        }
        catch (Exception e) {
            logger.warn("Exception while shutting down storage plugin: {}", (Object)(this.name == null ? "ephemeral" : this.config.getClass().getSimpleName()), (Object)e);
        }
        finally {
            this.plugin = null;
        }
    }

    public synchronized PluginHandle transfer(PluginType type) {
        if (this.plugin == null) {
            return new PluginHandle(this.name, this.config, this.connector, type);
        }
        PluginHandle newHandle = new PluginHandle(this.plugin, this.connector, type);
        this.plugin = null;
        return newHandle;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append(this.getClass().getSimpleName()).append("[").append("name=").append(this.name).append(", config=").append(this.config.toString()).append(", provider=").append(this.connector.getClass().getSimpleName()).append(", plugin=");
        if (this.plugin == null) {
            buf.append("null");
        } else {
            buf.append(this.plugin.getClass().getSimpleName()).append(" (").append(System.identityHashCode(this.plugin) % 1000).append(")");
        }
        return buf.append("]").toString();
    }

    static enum PluginType {
        INTRINSIC,
        STORED,
        EPHEMERAL;

    }
}

