/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeName;

public abstract class RecordDataType {
    public abstract List<AbstractMap.SimpleImmutableEntry<SqlTypeName, Boolean>> getFieldSqlTypeNames();

    public abstract List<String> getFieldNames();

    public final RelDataType getRowType(RelDataTypeFactory factory) {
        List<AbstractMap.SimpleImmutableEntry<SqlTypeName, Boolean>> types = this.getFieldSqlTypeNames();
        List<String> names = this.getFieldNames();
        ArrayList<RelDataType> fields = new ArrayList<RelDataType>();
        for (AbstractMap.SimpleImmutableEntry<SqlTypeName, Boolean> sqlTypePair : types) {
            RelDataType tempDataType;
            SqlTypeName typeName = sqlTypePair.getKey();
            switch (typeName) {
                case VARCHAR: {
                    tempDataType = factory.createSqlType(typeName, Integer.MAX_VALUE);
                    break;
                }
                default: {
                    tempDataType = factory.createSqlType(typeName);
                }
            }
            fields.add(factory.createTypeWithNullability(tempDataType, sqlTypePair.getValue().booleanValue()));
        }
        return factory.createStructType(fields, names);
    }
}

