/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.store.SchemaFactory;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.dfs.FormatPlugin;

public interface StoragePluginRegistry
extends Iterable<Map.Entry<String, StoragePlugin>>,
AutoCloseable {
    public static final String PSTORE_NAME = "sys.storage_plugins";

    public void init();

    public void put(String var1, StoragePluginConfig var2) throws PluginException;

    public void validatedPut(String var1, StoragePluginConfig var2) throws PluginException;

    public void setEnabled(String var1, boolean var2) throws PluginException;

    public StoragePlugin getPlugin(String var1) throws PluginException, UserException;

    public StoragePlugin getPluginByConfig(StoragePluginConfig var1) throws PluginException;

    @Deprecated
    public StoragePlugin getPlugin(StoragePluginConfig var1) throws ExecutionSetupException;

    public StoragePluginConfig getStoredConfig(String var1);

    public String encode(String var1) throws PluginException;

    public String encode(StoragePluginConfig var1);

    public StoragePluginConfig decode(String var1) throws PluginEncodingException;

    public void putJson(String var1, String var2) throws PluginException;

    public StoragePluginConfig copyConfig(String var1) throws PluginException;

    public StoragePluginConfig copyConfig(StoragePluginConfig var1);

    public StoragePluginConfig getDefinedConfig(String var1);

    public void remove(String var1) throws PluginException;

    public Map<String, StoragePluginConfig> storedConfigs();

    public Map<String, StoragePluginConfig> storedConfigs(PluginFilter var1);

    public Map<String, StoragePluginConfig> enabledConfigs();

    public Set<String> availablePlugins();

    public void putFormatPlugin(String var1, String var2, FormatPluginConfig var3) throws PluginException;

    public FormatPlugin getFormatPluginByConfig(StoragePluginConfig var1, FormatPluginConfig var2) throws PluginException;

    @Deprecated
    public FormatPlugin getFormatPlugin(StoragePluginConfig var1, FormatPluginConfig var2) throws ExecutionSetupException;

    public SchemaFactory getSchemaFactory();

    public ObjectMapper mapper();

    public <T extends StoragePlugin> T resolve(StoragePluginConfig var1, Class<T> var2);

    public <T extends FormatPlugin> T resolveFormat(StoragePluginConfig var1, FormatPluginConfig var2, Class<T> var3);

    public static enum PluginFilter {
        ALL,
        ENABLED,
        DISABLED,
        TRANSLATES_USERS;

    }

    public static class PluginEncodingException
    extends PluginException {
        public PluginEncodingException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class PluginNotFoundException
    extends PluginException {
        public PluginNotFoundException(String name) {
            super("No storage plugin exists with name: `" + name + "`");
        }
    }

    public static class PluginException
    extends Exception {
        public PluginException(String msg) {
            super(msg);
        }

        public PluginException(String msg, Throwable e) {
            super(msg, e);
        }

        public static PluginException systemPluginException(String operation, String name) {
            return new PluginException(String.format("Cannot %s a system plugin: `%s`", operation, name));
        }
    }
}

