/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.collections.ImmutableEntry;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.planner.logical.StoragePlugins;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.ClassicConnectorLocator;
import org.apache.drill.exec.store.ConnectorHandle;
import org.apache.drill.exec.store.ConnectorLocator;
import org.apache.drill.exec.store.DrillSchemaFactory;
import org.apache.drill.exec.store.DrillbitPluginRegistryContext;
import org.apache.drill.exec.store.PluginHandle;
import org.apache.drill.exec.store.PluginRegistryContext;
import org.apache.drill.exec.store.SchemaFactory;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.StoragePluginMap;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.StoragePluginStore;
import org.apache.drill.exec.store.StoragePluginStoreImpl;
import org.apache.drill.exec.store.SystemPluginLocator;
import org.apache.drill.exec.store.dfs.FileSystemConfig;
import org.apache.drill.exec.store.dfs.FormatPlugin;
import org.apache.drill.shaded.guava.com.google.common.cache.CacheBuilder;
import org.apache.drill.shaded.guava.com.google.common.cache.CacheLoader;
import org.apache.drill.shaded.guava.com.google.common.cache.LoadingCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoragePluginRegistryImpl
implements StoragePluginRegistry {
    private static final Logger logger = LoggerFactory.getLogger(StoragePluginRegistryImpl.class);
    private final PluginRegistryContext context;
    private final StoragePluginMap pluginCache;
    private final DrillSchemaFactory schemaFactory;
    private final StoragePluginStore pluginStore;
    private final LoadingCache<StoragePluginConfig, PluginHandle> ephemeralPlugins;
    private final List<ConnectorLocator> locators = new ArrayList<ConnectorLocator>();
    private final Map<Class<? extends StoragePluginConfig>, ConnectorHandle> connectors = new IdentityHashMap<Class<? extends StoragePluginConfig>, ConnectorHandle>();

    public StoragePluginRegistryImpl(DrillbitContext context) {
        this.context = new DrillbitPluginRegistryContext(context);
        this.pluginCache = new StoragePluginMap();
        this.schemaFactory = new DrillSchemaFactory(null);
        this.locators.add(new ClassicConnectorLocator(this.context));
        this.locators.add(new SystemPluginLocator(this.context));
        this.pluginStore = new StoragePluginStoreImpl(context);
        this.ephemeralPlugins = CacheBuilder.newBuilder().expireAfterAccess(24L, TimeUnit.HOURS).maximumSize(250L).removalListener(notification -> ((PluginHandle)notification.getValue()).close()).build(new CacheLoader<StoragePluginConfig, PluginHandle>(){

            @Override
            public PluginHandle load(StoragePluginConfig config) throws Exception {
                return StoragePluginRegistryImpl.this.createPluginEntry("$$ephemeral$$", config, PluginHandle.PluginType.EPHEMERAL);
            }
        });
    }

    @Override
    public void init() {
        this.locators.stream().forEach(loc -> loc.init());
        try {
            this.loadIntrinsicPlugins();
        }
        catch (StoragePluginRegistry.PluginException e) {
            throw new IllegalStateException("Failed to load system plugins", e);
        }
        this.defineConnectors();
        this.prepareStore();
    }

    private void loadIntrinsicPlugins() throws StoragePluginRegistry.PluginException {
        for (ConnectorLocator locator : this.locators) {
            Collection<StoragePlugin> intrinsicPlugins = locator.intrinsicPlugins();
            if (intrinsicPlugins == null) continue;
            for (StoragePlugin sysPlugin : intrinsicPlugins) {
                String lcName;
                String origName = sysPlugin.getName();
                if (!origName.equals(lcName = sysPlugin.getName().toLowerCase())) {
                    throw new IllegalStateException(String.format("Plugin names must be in lower case but system plugin name `%s` is not", origName));
                }
                ConnectorHandle connector = ConnectorHandle.intrinsicConnector(locator, sysPlugin);
                this.defineConnector(connector);
                this.pluginCache.put(new PluginHandle(sysPlugin, connector, PluginHandle.PluginType.INTRINSIC));
            }
        }
    }

    private void defineConnector(ConnectorHandle connector) {
        ConnectorHandle prev = this.connectors.put(connector.configClass(), connector);
        if (prev != null) {
            String msg = String.format("Two connectors defined for the same config: %s -> %s and %s -> %s", connector.configClass().getName(), connector.locator().getClass().getName(), prev.configClass().getName(), prev.locator().getClass().getName());
            logger.error(msg);
            throw new IllegalStateException(msg);
        }
    }

    private void defineConnectors() {
        for (ConnectorLocator locator : this.locators) {
            Set<Class<? extends StoragePluginConfig>> nonIntrinsicConfigs = locator.configClasses();
            if (nonIntrinsicConfigs == null) continue;
            for (Class<? extends StoragePluginConfig> configClass : nonIntrinsicConfigs) {
                this.defineConnector(ConnectorHandle.configuredConnector(locator, configClass));
            }
        }
    }

    private void prepareStore() {
        if (this.loadEnabledPlugins()) {
            this.upgradeStore();
        } else {
            this.initStore();
        }
    }

    private void initStore() {
        logger.info("No storage plugin instances configured in persistent store, loading bootstrap configuration.");
        StoragePlugins bootstrapPlugins = new StoragePlugins();
        try {
            for (ConnectorLocator locator : this.locators) {
                StoragePlugins locatorPlugins = locator.bootstrapPlugins();
                bootstrapPlugins.putAll(locatorPlugins);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failure initializing the plugin store. Drillbit exiting.", e);
        }
        this.pluginStore.putAll(bootstrapPlugins);
        this.locators.forEach(ConnectorLocator::onUpgrade);
    }

    private void upgradeStore() {
        StoragePlugins upgraded = new StoragePlugins();
        for (ConnectorLocator locator : this.locators) {
            StoragePlugins locatorPlugins = locator.updatedPlugins();
            upgraded.putAll(locatorPlugins);
        }
        if (upgraded.isEmpty()) {
            return;
        }
        for (Map.Entry newPlugin : upgraded) {
            StoragePluginConfig oldPluginConfig = this.getStoredConfig((String)newPlugin.getKey());
            if (oldPluginConfig != null) {
                StoragePluginRegistryImpl.copyPluginStatus(oldPluginConfig, (StoragePluginConfig)newPlugin.getValue());
            }
            this.pluginStore.put((String)newPlugin.getKey(), (StoragePluginConfig)newPlugin.getValue());
        }
        this.locators.forEach(ConnectorLocator::onUpgrade);
    }

    protected static void copyPluginStatus(StoragePluginConfig oldPluginConfig, StoragePluginConfig newPluginConfig) {
        if (!newPluginConfig.isEnabledStatusPresent()) {
            boolean newStatus = oldPluginConfig != null && oldPluginConfig.isEnabled();
            newPluginConfig.setEnabled(newStatus);
        }
    }

    private boolean loadEnabledPlugins() {
        Iterator<Map.Entry<String, StoragePluginConfig>> allPlugins = this.pluginStore.load();
        int count = 0;
        while (allPlugins.hasNext()) {
            ++count;
            Map.Entry<String, StoragePluginConfig> plugin = allPlugins.next();
            String name = plugin.getKey();
            StoragePluginConfig config = plugin.getValue();
            if (!config.isEnabled()) continue;
            try {
                this.pluginCache.put(this.createPluginEntry(name, config, PluginHandle.PluginType.STORED));
            }
            catch (Exception e) {
                logger.error("Failure while setting up StoragePlugin with name: '{}', disabling.", (Object)name, (Object)e);
                config.setEnabled(false);
                this.pluginStore.put(name, config);
            }
        }
        return count > 0;
    }

    @Override
    public void put(String name, StoragePluginConfig config) throws StoragePluginRegistry.PluginException {
        PluginHandle currentEntry = this.pluginCache.get(name = this.validateName(name));
        if (currentEntry != null && currentEntry.isIntrinsic()) {
            throw StoragePluginRegistry.PluginException.systemPluginException("replace", name);
        }
        this.pluginStore.put(name, config);
    }

    private String validateName(String name) throws StoragePluginRegistry.PluginException {
        if (name == null) {
            throw new StoragePluginRegistry.PluginException("Plugin name cannot be null");
        }
        if ((name = name.trim().toLowerCase()).isEmpty()) {
            throw new StoragePluginRegistry.PluginException("Plugin name cannot be null");
        }
        return name;
    }

    @Override
    public void validatedPut(String name, StoragePluginConfig config) throws StoragePluginRegistry.PluginException {
        PluginHandle oldEntry;
        Exception lifecycleException = null;
        name = this.validateName(name);
        if (config.isEnabled()) {
            PluginHandle entry = this.restoreFromEphemeral(name, config);
            try {
                entry.plugin();
            }
            catch (UserException e) {
                throw new StoragePluginRegistry.PluginException(e.getOriginalMessage(), e);
            }
            catch (Exception e) {
                throw new StoragePluginRegistry.PluginException(String.format("Invalid plugin config for '%s', Please switch to Logs panel from the UI then check the log.", name), e);
            }
            oldEntry = this.pluginCache.put(entry);
            try {
                if (oldEntry == null || !oldEntry.config().isEnabled()) {
                    entry.plugin().onEnabled();
                }
            }
            catch (Exception e) {
                lifecycleException = e;
            }
        } else {
            oldEntry = this.pluginCache.remove(name);
            try {
                if (oldEntry != null && oldEntry.config().isEnabled()) {
                    oldEntry.plugin().onDisabled();
                }
            }
            catch (Exception e) {
                lifecycleException = e;
            }
        }
        this.moveToEphemeral(oldEntry);
        this.pluginStore.put(name, config);
        if (lifecycleException != null) {
            throw new StoragePluginRegistry.PluginException(String.format("A lifecycle method in plugin %s failed. The initiating plugin config update has not been rolled back.", name), lifecycleException);
        }
    }

    @Override
    public void setEnabled(String name, boolean enable) throws StoragePluginRegistry.PluginException {
        StoragePluginConfig config = this.requireStoredConfig(name = this.validateName(name));
        if (config.isEnabled() == enable) {
            return;
        }
        StoragePluginConfig copy = this.copyConfig(config);
        copy.setEnabled(enable);
        this.validatedPut(name, copy);
    }

    @Override
    public StoragePluginConfig getStoredConfig(String name) {
        return this.pluginStore.get(name);
    }

    @Override
    public StoragePluginConfig copyConfig(String name) throws StoragePluginRegistry.PluginException {
        return this.copyConfig(this.requireStoredConfig(name));
    }

    private StoragePluginConfig requireStoredConfig(String name) throws StoragePluginRegistry.PluginException {
        StoragePluginConfig config = this.getStoredConfig(name);
        if (config == null) {
            throw new StoragePluginRegistry.PluginNotFoundException(name);
        }
        return config;
    }

    @Override
    public String encode(StoragePluginConfig config) {
        ObjectMapper mapper = this.context.mapper();
        try {
            return mapper.writer().forType(config.getClass()).writeValueAsString((Object)config);
        }
        catch (IOException e) {
            throw new IllegalStateException("Serialize failed", e);
        }
    }

    @Override
    public String encode(String name) throws StoragePluginRegistry.PluginException {
        return this.encode(this.requireStoredConfig(this.validateName(name)));
    }

    @Override
    public StoragePluginConfig decode(String json) throws StoragePluginRegistry.PluginEncodingException {
        try {
            return (StoragePluginConfig)this.context.mapper().reader().forType(StoragePluginConfig.class).readValue(json);
        }
        catch (InvalidTypeIdException | UnrecognizedPropertyException e) {
            throw new StoragePluginRegistry.PluginEncodingException(e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new StoragePluginRegistry.PluginEncodingException("Failure when decoding plugin JSON", e);
        }
    }

    @Override
    public void putJson(String name, String json) throws StoragePluginRegistry.PluginException {
        this.validatedPut(name, this.decode(json));
    }

    @Override
    public StoragePluginConfig copyConfig(StoragePluginConfig orig) {
        try {
            return this.decode(this.encode(orig));
        }
        catch (StoragePluginRegistry.PluginEncodingException e) {
            throw new IllegalStateException("De/serialize failed", e);
        }
    }

    @Override
    public StoragePluginConfig getDefinedConfig(String name) {
        try {
            name = this.validateName(name);
        }
        catch (StoragePluginRegistry.PluginException e) {
            return null;
        }
        PluginHandle entry = this.getEntry(name);
        return entry == null ? null : entry.config();
    }

    @Override
    public StoragePlugin getPlugin(String name) throws StoragePluginRegistry.PluginException {
        try {
            name = this.validateName(name);
        }
        catch (StoragePluginRegistry.PluginException e) {
            return null;
        }
        PluginHandle entry = this.getEntry(name);
        return entry == null ? null : entry.plugin();
    }

    private PluginHandle getEntry(String name) {
        PluginHandle plugin = this.pluginCache.get(name);
        if (plugin != null && plugin.isIntrinsic()) {
            return plugin;
        }
        StoragePluginConfig config = this.getStoredConfig(name);
        if (plugin == null) {
            return this.refresh(name, config);
        }
        return this.refresh(plugin, config);
    }

    private PluginHandle refresh(String name, StoragePluginConfig config) {
        if (config == null || !config.isEnabled()) {
            return null;
        }
        return this.pluginCache.putIfAbsent(this.restoreFromEphemeral(name, config));
    }

    private PluginHandle refresh(PluginHandle entry, StoragePluginConfig config) {
        if (config == null || !config.isEnabled()) {
            try {
                if (this.pluginCache.remove(entry.name()) == entry) {
                    this.moveToEphemeral(entry);
                }
                return null;
            }
            catch (StoragePluginRegistry.PluginException e) {
                throw new IllegalStateException("Plugin refresh failed", e);
            }
        }
        if (entry.config().equals(config)) {
            return entry;
        }
        PluginHandle newEntry = this.restoreFromEphemeral(entry.name(), config);
        try {
            if (this.pluginCache.replace(entry, newEntry)) {
                this.moveToEphemeral(entry);
                return newEntry;
            }
            return this.pluginCache.get(entry.name());
        }
        catch (StoragePluginRegistry.PluginException e) {
            throw new IllegalStateException("Plugin refresh failed", e);
        }
    }

    private void refresh() {
        Iterator<Map.Entry<String, StoragePluginConfig>> allPlugins = this.pluginStore.load();
        while (allPlugins.hasNext()) {
            Map.Entry<String, StoragePluginConfig> plugin = allPlugins.next();
            this.refresh(plugin.getKey(), plugin.getValue());
        }
    }

    @Override
    public StoragePlugin getPlugin(StoragePluginConfig config) throws ExecutionSetupException {
        try {
            return this.getPluginByConfig(config);
        }
        catch (StoragePluginRegistry.PluginException e) {
            throw this.translateException(e);
        }
    }

    private ExecutionSetupException translateException(StoragePluginRegistry.PluginException e) {
        Throwable cause = e.getCause();
        if (cause != null && cause instanceof ExecutionSetupException) {
            return (ExecutionSetupException)cause;
        }
        return new ExecutionSetupException(e);
    }

    @Override
    public StoragePlugin getPluginByConfig(StoragePluginConfig config) throws StoragePluginRegistry.PluginException {
        PluginHandle plugin = this.pluginCache.get(config);
        if (plugin != null) {
            return plugin.plugin();
        }
        try {
            return this.ephemeralPlugins.get(config).plugin();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StoragePluginRegistry.PluginException) {
                throw (StoragePluginRegistry.PluginException)cause;
            }
            throw new StoragePluginRegistry.PluginException("Failure while trying to create ephemeral plugin.", cause);
        }
    }

    @Override
    public void remove(String name) throws StoragePluginRegistry.PluginException {
        name = this.validateName(name);
        this.moveToEphemeral(this.pluginCache.remove(name));
        this.pluginStore.delete(name);
    }

    private PluginHandle restoreFromEphemeral(String name, StoragePluginConfig config) {
        PluginHandle ephemeralEntry = (PluginHandle)this.ephemeralPlugins.getIfPresent(config);
        if (ephemeralEntry == null || !name.equalsIgnoreCase(ephemeralEntry.name())) {
            return this.createPluginEntry(name, config, PluginHandle.PluginType.STORED);
        }
        PluginHandle newHandle = ephemeralEntry.transfer(PluginHandle.PluginType.STORED);
        this.ephemeralPlugins.invalidate(config);
        return newHandle;
    }

    private void moveToEphemeral(PluginHandle handle) {
        if (handle == null) {
            return;
        }
        if (!handle.hasInstance()) {
            return;
        }
        if (this.ephemeralPlugins.getIfPresent(handle.config()) == null) {
            this.ephemeralPlugins.put(handle.config(), handle.transfer(PluginHandle.PluginType.EPHEMERAL));
        } else {
            handle.close();
        }
    }

    @Override
    public Map<String, StoragePluginConfig> storedConfigs() {
        return this.storedConfigs(StoragePluginRegistry.PluginFilter.ALL);
    }

    @Override
    public Map<String, StoragePluginConfig> storedConfigs(StoragePluginRegistry.PluginFilter filter) {
        HashMap<String, StoragePluginConfig> result = new HashMap<String, StoragePluginConfig>();
        Iterator<Map.Entry<String, StoragePluginConfig>> allPlugins = this.pluginStore.load();
        while (allPlugins.hasNext()) {
            boolean include;
            Map.Entry<String, StoragePluginConfig> plugin = allPlugins.next();
            switch (filter) {
                case ENABLED: {
                    include = plugin.getValue().isEnabled();
                    break;
                }
                case DISABLED: {
                    include = !plugin.getValue().isEnabled();
                    break;
                }
                case TRANSLATES_USERS: {
                    include = plugin.getValue().getAuthMode() == StoragePluginConfig.AuthMode.USER_TRANSLATION && plugin.getValue().isEnabled();
                    break;
                }
                default: {
                    include = true;
                }
            }
            if (!include) continue;
            result.put(plugin.getKey(), plugin.getValue());
        }
        return result;
    }

    @Override
    public Map<String, StoragePluginConfig> enabledConfigs() {
        this.refresh();
        HashMap<String, StoragePluginConfig> result = new HashMap<String, StoragePluginConfig>();
        for (PluginHandle entry : this.pluginCache) {
            if (!entry.isStored()) continue;
            result.put(entry.name(), entry.config());
        }
        return result;
    }

    @Override
    public void putFormatPlugin(String pluginName, String formatName, FormatPluginConfig formatConfig) throws StoragePluginRegistry.PluginException {
        pluginName = this.validateName(pluginName);
        formatName = this.validateName(formatName);
        StoragePluginConfig orig = this.requireStoredConfig(pluginName);
        if (!(orig instanceof FileSystemConfig)) {
            throw new StoragePluginRegistry.PluginException("Format plugins can be added only to the file system plugin: " + pluginName);
        }
        FileSystemConfig copy = (FileSystemConfig)this.copyConfig(orig);
        if (formatConfig == null) {
            copy.getFormats().remove(formatName);
        } else {
            copy.getFormats().put(formatName, formatConfig);
        }
        this.put(pluginName, copy);
    }

    @Override
    public FormatPlugin getFormatPluginByConfig(StoragePluginConfig storageConfig, FormatPluginConfig formatConfig) throws StoragePluginRegistry.PluginException {
        StoragePlugin storagePlugin = this.getPluginByConfig(storageConfig);
        return storagePlugin.getFormatPlugin(formatConfig);
    }

    @Override
    public FormatPlugin getFormatPlugin(StoragePluginConfig storageConfig, FormatPluginConfig formatConfig) throws ExecutionSetupException {
        try {
            return this.getFormatPluginByConfig(storageConfig, formatConfig);
        }
        catch (StoragePluginRegistry.PluginException e) {
            throw this.translateException(e);
        }
    }

    @Override
    public SchemaFactory getSchemaFactory() {
        return this.schemaFactory;
    }

    @Override
    public Iterator<Map.Entry<String, StoragePlugin>> iterator() {
        this.refresh();
        return new PluginIterator(this.pluginCache.iterator());
    }

    @Override
    public synchronized void close() throws Exception {
        this.ephemeralPlugins.invalidateAll();
        this.pluginCache.close();
        this.pluginStore.close();
        this.locators.forEach(loc -> loc.close());
    }

    private PluginHandle createPluginEntry(String name, StoragePluginConfig pluginConfig, PluginHandle.PluginType type) {
        ConnectorHandle connector = this.connectors.get(pluginConfig.getClass());
        if (connector == null) {
            throw UserException.internalError().message("No connector known for plugin configuration", new Object[0]).addContext("Plugin name", name).addContext("Config class", pluginConfig.getClass().getName()).build(logger);
        }
        return connector.pluginEntryFor(name, pluginConfig, type);
    }

    @Override
    public ObjectMapper mapper() {
        return this.context.mapper();
    }

    @Override
    public <T extends StoragePlugin> T resolve(StoragePluginConfig storageConfig, Class<T> desired) {
        try {
            return (T)((StoragePlugin)desired.cast(this.getPluginByConfig(storageConfig)));
        }
        catch (ClassCastException | StoragePluginRegistry.PluginException e) {
            throw new IllegalStateException(String.format("Unable to load stroage plugin %s for provided config class %s", desired.getName(), storageConfig.getClass().getName()), e);
        }
    }

    @Override
    public <T extends FormatPlugin> T resolveFormat(StoragePluginConfig storageConfig, FormatPluginConfig formatConfig, Class<T> desired) {
        try {
            return (T)((FormatPlugin)desired.cast(this.getFormatPluginByConfig(storageConfig, formatConfig)));
        }
        catch (ClassCastException | StoragePluginRegistry.PluginException e) {
            throw new IllegalStateException(String.format("Unable to load format plugin %s for provided plugin config class %s and format config class %s", desired.getName(), storageConfig.getClass().getName(), formatConfig.getClass().getName()), e);
        }
    }

    @Override
    public Set<String> availablePlugins() {
        this.refresh();
        return this.pluginCache.names();
    }

    private static class PluginIterator
    implements Iterator<Map.Entry<String, StoragePlugin>> {
        private final Iterator<PluginHandle> base;
        private PluginHandle entry;

        public PluginIterator(Iterator<PluginHandle> base) {
            this.base = base;
        }

        @Override
        public boolean hasNext() {
            while (this.base.hasNext()) {
                this.entry = this.base.next();
                try {
                    this.entry.plugin();
                    return true;
                }
                catch (Exception exception) {
                }
            }
            return false;
        }

        @Override
        public Map.Entry<String, StoragePlugin> next() {
            return new ImmutableEntry<String, StoragePlugin>(this.entry.name(), this.entry.plugin());
        }
    }
}

