/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Table;
import org.apache.drill.exec.planner.logical.CreateTableEntry;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.PartitionNotFoundException;
import org.apache.drill.exec.store.StorageStrategy;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

public class SubSchemaWrapper
extends AbstractSchema {
    private final AbstractSchema innerSchema;

    public SubSchemaWrapper(AbstractSchema innerSchema) {
        super(ImmutableList.of(), innerSchema.getFullSchemaName());
        this.innerSchema = innerSchema;
    }

    @Override
    public boolean showInInformationSchema() {
        return false;
    }

    @Override
    public Iterable<String> getSubPartitions(String table, List<String> partitionColumns, List<String> partitionValues) throws PartitionNotFoundException {
        Schema defaultSchema = this.getDefaultSchema();
        if (defaultSchema instanceof AbstractSchema) {
            return ((AbstractSchema)defaultSchema).getSubPartitions(table, partitionColumns, partitionValues);
        }
        return Collections.emptyList();
    }

    @Override
    public Schema getDefaultSchema() {
        return this.innerSchema.getDefaultSchema();
    }

    @Override
    public CreateTableEntry createNewTable(String tableName, List<String> partitionColumns, StorageStrategy storageStrategy) {
        return this.innerSchema.createNewTable(tableName, partitionColumns, storageStrategy);
    }

    @Override
    public CreateTableEntry createStatsTable(String tableName) {
        return this.innerSchema.createStatsTable(tableName);
    }

    @Override
    public CreateTableEntry appendToStatsTable(String tableName) {
        return this.innerSchema.appendToStatsTable(tableName);
    }

    @Override
    public Table getStatsTable(String tableName) {
        return this.innerSchema.getStatsTable(tableName);
    }

    @Override
    public Collection<Function> getFunctions(String name) {
        return this.innerSchema.getFunctions(name);
    }

    @Override
    public Set<String> getFunctionNames() {
        return this.innerSchema.getFunctionNames();
    }

    @Override
    public Schema getSubSchema(String name) {
        return this.innerSchema.getSubSchema(name);
    }

    @Override
    public Set<String> getSubSchemaNames() {
        return this.innerSchema.getSubSchemaNames();
    }

    @Override
    public boolean isMutable() {
        return this.innerSchema.isMutable();
    }

    @Override
    public Table getTable(String name) {
        return this.innerSchema.getTable(name);
    }

    @Override
    public Set<String> getTableNames() {
        return this.innerSchema.getTableNames();
    }

    @Override
    public String getTypeName() {
        return this.innerSchema.getTypeName();
    }
}

