/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.apache.drill.common.scanner.persistence.AnnotatedClassDescriptor;
import org.apache.drill.exec.planner.logical.StoragePlugins;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.ConnectorLocator;
import org.apache.drill.exec.store.PluginRegistryContext;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.SystemPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPluginLocator
implements ConnectorLocator {
    private static final Logger logger = LoggerFactory.getLogger(SystemPluginLocator.class);
    private final PluginRegistryContext context;
    private final Map<String, StoragePlugin> plugins = CaseInsensitiveMap.newHashMap();

    public SystemPluginLocator(PluginRegistryContext context) {
        this.context = context;
    }

    @Override
    public void init() {
        List<AnnotatedClassDescriptor> annotatedClasses = this.context.classpathScan().getAnnotatedClasses(SystemPlugin.class.getName());
        logger.trace("Found {} annotated classes with SystemPlugin annotation: {}.", (Object)annotatedClasses.size(), annotatedClasses);
        for (AnnotatedClassDescriptor annotatedClass : annotatedClasses) {
            try {
                this.loadPlugin(annotatedClass);
            }
            catch (ReflectiveOperationException e) {
                logger.warn("Error during system plugin {} initialization. Plugin initialization will be skipped.", (Object)annotatedClass.getClassName(), (Object)e);
            }
        }
        logger.trace("The following system plugins have been initialized: {}.", this.plugins.keySet());
    }

    private void loadPlugin(AnnotatedClassDescriptor annotatedClass) throws ReflectiveOperationException {
        Class<?> aClass = Class.forName(annotatedClass.getClassName());
        for (Constructor<?> constructor : aClass.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 1 || parameterTypes[0] != DrillbitContext.class) {
                logger.trace("Not matching constructor for {}. Expecting constructor with one parameter for DrillbitContext class.", (Object)annotatedClass.getClassName());
                continue;
            }
            Object instance = constructor.newInstance(this.context.drillbitContext());
            if (!(instance instanceof StoragePlugin)) {
                logger.debug("Created instance of {} does not implement StoragePlugin interface.", (Object)annotatedClass.getClassName());
                continue;
            }
            StoragePlugin storagePlugin = (StoragePlugin)instance;
            String name = storagePlugin.getName();
            if (name == null) {
                logger.debug("Storage plugin name {} is not defined. Skipping plugin initialization.", (Object)annotatedClass.getClassName());
                continue;
            }
            storagePlugin.getConfig().setEnabled(true);
            this.plugins.put(name, storagePlugin);
            return;
        }
        logger.debug("Skipping plugin registration for {}, did not find matching constructor or initialized object of wrong type.", (Object)aClass.getName());
    }

    @Override
    public StoragePlugins bootstrapPlugins() throws IOException {
        return null;
    }

    @Override
    public StoragePlugins updatedPlugins() {
        return null;
    }

    @Override
    public void onUpgrade() {
    }

    @Override
    public StoragePlugin get(String name) {
        return this.plugins.get(name);
    }

    @Override
    public Collection<StoragePlugin> intrinsicPlugins() {
        return this.plugins.values();
    }

    @Override
    public StoragePlugin create(String name, StoragePluginConfig pluginConfig) {
        throw new IllegalStateException("Should not create instances of system plugins");
    }

    @Override
    public Set<Class<? extends StoragePluginConfig>> configClasses() {
        return null;
    }

    @Override
    public boolean storable() {
        return false;
    }

    @Override
    public Class<? extends StoragePlugin> connectorClassFor(Class<? extends StoragePluginConfig> configClass) {
        for (StoragePlugin plugin : this.plugins.values()) {
            if (!configClass.isInstance(plugin.getConfig())) continue;
            return plugin.getClass();
        }
        return null;
    }

    @Override
    public void close() {
    }
}

