/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.avro;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

@JsonTypeName(value="avro")
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class AvroFormatConfig
implements FormatPluginConfig {
    private final List<String> extensions;

    @JsonCreator
    public AvroFormatConfig(@JsonProperty(value="extensions") List<String> extensions) {
        this.extensions = extensions == null ? Collections.singletonList("avro") : ImmutableList.copyOf(extensions);
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public int hashCode() {
        return Objects.hash(this.extensions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroFormatConfig that = (AvroFormatConfig)o;
        return Objects.equals(this.extensions, that.extensions);
    }

    public String toString() {
        return new PlanStringBuilder(this).field("extensions", this.extensions).toString();
    }
}

