/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.base.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.store.base.filter.ConstantHolder;
import org.apache.drill.exec.store.base.filter.RelOp;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public abstract class ExprNode {
    @JsonIgnore
    private RexNode rexNode = null;

    public void tag(RexNode rexNode) {
        this.rexNode = rexNode;
    }

    public RexNode rexNode() {
        return this.rexNode;
    }

    public abstract double selectivity();

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"colName", "op", "value"})
    public static class ColRelOpConstNode
    extends RelOpNode {
        @JsonProperty(value="colName")
        public final String colName;
        @JsonProperty(value="value")
        public final ConstantHolder value;

        @JsonCreator
        public ColRelOpConstNode(@JsonProperty(value="colName") String colName, @JsonProperty(value="op") RelOp op, @JsonProperty(value="value") ConstantHolder value) {
            super(op);
            Preconditions.checkArgument(op.argCount() == 1 || value != null);
            this.colName = colName;
            this.value = value;
        }

        public ColRelOpConstNode(ColRelOpConstNode from, ConstantHolder value) {
            super(from.op);
            Preconditions.checkArgument(from.op.argCount() == 2);
            this.colName = from.colName;
            this.value = value;
        }

        public ColRelOpConstNode normalize(ConstantHolder normalizedValue) {
            if (this.value == normalizedValue) {
                return this;
            }
            return new ColRelOpConstNode(this, normalizedValue);
        }

        public ColRelOpConstNode rewrite(String newName, ConstantHolder newValue) {
            if (this.value == newValue && this.colName.equals(newName)) {
                return this;
            }
            return new ColRelOpConstNode(newName, this.op, newValue);
        }

        public String toString() {
            PlanStringBuilder builder = new PlanStringBuilder(this).field("op", this.op.name()).field("colName", this.colName);
            if (this.value != null) {
                builder.field("type", this.value.type.name()).field("value", this.value.value);
            }
            return builder.toString();
        }
    }

    public static abstract class RelOpNode
    extends ExprNode {
        @JsonProperty(value="op")
        public final RelOp op;

        public RelOpNode(RelOp op) {
            this.op = op;
        }

        @Override
        public double selectivity() {
            return this.op.selectivity();
        }
    }

    public static class OrNode
    extends ListNode {
        @JsonCreator
        public OrNode(@JsonProperty(value="children") List<ExprNode> children) {
            super(children);
        }

        @Override
        public double selectivity() {
            if (this.children.size() == 0) {
                return 1.0;
            }
            double selectivity = 0.0;
            for (ExprNode child : this.children) {
                selectivity += child.selectivity();
            }
            return Math.min(0.9, selectivity);
        }
    }

    public static class AndNode
    extends ListNode {
        @JsonCreator
        public AndNode(@JsonProperty(value="children") List<ExprNode> children) {
            super(children);
        }

        @Override
        public double selectivity() {
            double selectivity = 1.0;
            for (ExprNode child : this.children) {
                selectivity *= child.selectivity();
            }
            return selectivity;
        }
    }

    public static abstract class ListNode
    extends ExprNode {
        @JsonProperty(value="children")
        public final List<ExprNode> children;

        public ListNode(List<ExprNode> children) {
            this.children = children;
        }
    }

    public static interface ColumnTypeNode {
        public String colName();

        public TypeProtos.MinorType type();
    }
}

