/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.base.filter;

public enum RelOp {
    EQ,
    NE,
    LT,
    LE,
    GE,
    GT,
    IS_NULL,
    IS_NOT_NULL;


    public RelOp invert() {
        switch (this) {
            case LT: {
                return GT;
            }
            case LE: {
                return GE;
            }
            case GT: {
                return LT;
            }
            case GE: {
                return LE;
            }
        }
        return this;
    }

    public int argCount() {
        switch (this) {
            case IS_NULL: 
            case IS_NOT_NULL: {
                return 1;
            }
        }
        return 2;
    }

    public double selectivity() {
        switch (this) {
            case EQ: {
                return 0.15;
            }
            case LT: 
            case LE: 
            case GT: 
            case GE: 
            case NE: {
                return 0.5;
            }
            case IS_NULL: 
            case IS_NOT_NULL: {
                return 0.9;
            }
        }
        return 0.25;
    }
}

