/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.drill.exec.ops.OperatorStats;
import org.apache.drill.exec.store.dfs.DrillFSDataInputStream;
import org.apache.drill.exec.store.dfs.OpenFileTracker;
import org.apache.drill.exec.util.AssertionUtil;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillFileSystem
extends FileSystem
implements OpenFileTracker {
    private static final Logger logger = LoggerFactory.getLogger(DrillFileSystem.class);
    private static final boolean TRACKING_ENABLED = AssertionUtil.isAssertionsEnabled();
    public static final String UNDERSCORE_PREFIX = "_";
    public static final String DOT_PREFIX = ".";
    private final ConcurrentMap<DrillFSDataInputStream, DebugStackTrace> openedFiles = Maps.newConcurrentMap();
    private final FileSystem underlyingFs;
    private final OperatorStats operatorStats;
    private final CompressionCodecFactory codecFactory;

    public DrillFileSystem(Configuration fsConf) throws IOException {
        this(fsConf, null);
    }

    public DrillFileSystem(Configuration fsConf, OperatorStats operatorStats) throws IOException {
        fsConf = new Configuration(fsConf);
        this.underlyingFs = FileSystem.get((Configuration)fsConf);
        this.codecFactory = new CompressionCodecFactory(fsConf);
        this.operatorStats = operatorStats;
    }

    private void throwUnsupported() {
        throw new UnsupportedOperationException(DrillFileSystem.class.getCanonicalName() + " is immutable and should not be changed after creation.");
    }

    public void setConf(Configuration conf) {
        if (this.underlyingFs != null) {
            this.throwUnsupported();
        }
    }

    public Configuration getConf() {
        return new Configuration(this.underlyingFs.getConf());
    }

    public FileSystem getUnderlyingFs() {
        return this.underlyingFs;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        if (this.operatorStats == null) {
            return this.underlyingFs.open(f, bufferSize);
        }
        if (TRACKING_ENABLED) {
            DrillFSDataInputStream is = new DrillFSDataInputStream(this.underlyingFs.open(f, bufferSize), this.operatorStats, this);
            this.fileOpened(f, is);
            return is;
        }
        return new DrillFSDataInputStream(this.underlyingFs.open(f, bufferSize), this.operatorStats);
    }

    public FSDataInputStream open(Path f) throws IOException {
        if (this.operatorStats == null) {
            return this.underlyingFs.open(f);
        }
        if (TRACKING_ENABLED) {
            DrillFSDataInputStream is = new DrillFSDataInputStream(this.underlyingFs.open(f), this.operatorStats, this);
            this.fileOpened(f, is);
            return is;
        }
        return new DrillFSDataInputStream(this.underlyingFs.open(f), this.operatorStats);
    }

    public void initialize(URI name, Configuration conf) {
        this.throwUnsupported();
    }

    public String getScheme() {
        return this.underlyingFs.getScheme();
    }

    public FSDataOutputStream create(Path f) throws IOException {
        return this.underlyingFs.create(f);
    }

    public FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        return this.underlyingFs.create(f, overwrite);
    }

    public FSDataOutputStream create(Path f, Progressable progress) throws IOException {
        return this.underlyingFs.create(f, progress);
    }

    public FSDataOutputStream create(Path f, short replication) throws IOException {
        return this.underlyingFs.create(f, replication);
    }

    public FSDataOutputStream create(Path f, short replication, Progressable progress) throws IOException {
        return this.underlyingFs.create(f, replication, progress);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize) throws IOException {
        return this.underlyingFs.create(f, overwrite, bufferSize);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, Progressable progress) throws IOException {
        return this.underlyingFs.create(f, overwrite, bufferSize, progress);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        return this.underlyingFs.create(f, overwrite, bufferSize, replication, blockSize);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.underlyingFs.create(f, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        return this.underlyingFs.getFileStatus(f);
    }

    public void createSymlink(Path target, Path link, boolean createParent) throws IOException {
        this.underlyingFs.createSymlink(target, link, createParent);
    }

    public FileStatus getFileLinkStatus(Path f) throws IOException {
        return this.underlyingFs.getFileLinkStatus(f);
    }

    public boolean supportsSymlinks() {
        return this.underlyingFs.supportsSymlinks();
    }

    public Path getLinkTarget(Path f) throws IOException {
        return this.underlyingFs.getLinkTarget(f);
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        return this.underlyingFs.getFileChecksum(f);
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        this.throwUnsupported();
    }

    public void setWriteChecksum(boolean writeChecksum) {
        this.throwUnsupported();
    }

    public FsStatus getStatus() throws IOException {
        return this.underlyingFs.getStatus();
    }

    public FsStatus getStatus(Path p) throws IOException {
        return this.underlyingFs.getStatus(p);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.underlyingFs.setPermission(p, permission);
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        this.underlyingFs.setOwner(p, username, groupname);
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.underlyingFs.setTimes(p, mtime, atime);
    }

    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        return this.underlyingFs.createSnapshot(path, snapshotName);
    }

    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        this.underlyingFs.renameSnapshot(path, snapshotOldName, snapshotNewName);
    }

    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        this.underlyingFs.deleteSnapshot(path, snapshotName);
    }

    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.underlyingFs.modifyAclEntries(path, aclSpec);
    }

    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.underlyingFs.removeAclEntries(path, aclSpec);
    }

    public void removeDefaultAcl(Path path) throws IOException {
        this.underlyingFs.removeDefaultAcl(path);
    }

    public void removeAcl(Path path) throws IOException {
        this.underlyingFs.removeAcl(path);
    }

    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        this.underlyingFs.setAcl(path, aclSpec);
    }

    public AclStatus getAclStatus(Path path) throws IOException {
        return this.underlyingFs.getAclStatus(path);
    }

    public Path getWorkingDirectory() {
        return this.underlyingFs.getWorkingDirectory();
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return this.underlyingFs.append(f, bufferSize, progress);
    }

    public void concat(Path trg, Path[] psrcs) throws IOException {
        this.underlyingFs.concat(trg, psrcs);
    }

    @Deprecated
    public short getReplication(Path src) throws IOException {
        return this.underlyingFs.getReplication(src);
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        return this.underlyingFs.setReplication(src, replication);
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.underlyingFs.mkdirs(f, permission);
    }

    public void copyFromLocalFile(Path src, Path dst) throws IOException {
        this.underlyingFs.copyFromLocalFile(src, dst);
    }

    public void moveFromLocalFile(Path[] srcs, Path dst) throws IOException {
        this.underlyingFs.moveFromLocalFile(srcs, dst);
    }

    public void moveFromLocalFile(Path src, Path dst) throws IOException {
        this.underlyingFs.moveFromLocalFile(src, dst);
    }

    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.underlyingFs.copyFromLocalFile(delSrc, src, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        this.underlyingFs.copyFromLocalFile(delSrc, overwrite, srcs, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        this.underlyingFs.copyFromLocalFile(delSrc, overwrite, src, dst);
    }

    public void copyToLocalFile(Path src, Path dst) throws IOException {
        this.underlyingFs.copyToLocalFile(src, dst);
    }

    public void moveToLocalFile(Path src, Path dst) throws IOException {
        this.underlyingFs.moveToLocalFile(src, dst);
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.underlyingFs.copyToLocalFile(delSrc, src, dst);
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst, boolean useRawLocalFileSystem) throws IOException {
        this.underlyingFs.copyToLocalFile(delSrc, src, dst, useRawLocalFileSystem);
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return this.underlyingFs.startLocalOutput(fsOutputFile, tmpLocalFile);
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        this.underlyingFs.completeLocalOutput(fsOutputFile, tmpLocalFile);
    }

    public void close() throws IOException {
        if (TRACKING_ENABLED && this.openedFiles.size() != 0) {
            StringBuffer errMsgBuilder = new StringBuffer();
            errMsgBuilder.append(String.format("Not all files opened using this FileSystem are closed. There are still [%d] files open.\n", this.openedFiles.size()));
            for (DebugStackTrace stackTrace : this.openedFiles.values()) {
                stackTrace.addToStringBuilder(errMsgBuilder);
            }
            String errMsg = errMsgBuilder.toString();
            logger.error(errMsg);
            throw new IllegalStateException(errMsg);
        }
    }

    public long getUsed() throws IOException {
        return this.underlyingFs.getUsed();
    }

    @Deprecated
    public long getBlockSize(Path f) throws IOException {
        return this.underlyingFs.getBlockSize(f);
    }

    @Deprecated
    public long getDefaultBlockSize() {
        return this.underlyingFs.getDefaultBlockSize();
    }

    public long getDefaultBlockSize(Path f) {
        return this.underlyingFs.getDefaultBlockSize(f);
    }

    @Deprecated
    public short getDefaultReplication() {
        return this.underlyingFs.getDefaultReplication();
    }

    public short getDefaultReplication(Path path) {
        return this.underlyingFs.getDefaultReplication(path);
    }

    public boolean mkdirs(Path folderPath) throws IOException {
        if (!this.underlyingFs.exists(folderPath)) {
            return this.underlyingFs.mkdirs(folderPath);
        }
        if (!this.underlyingFs.getFileStatus(folderPath).isDir()) {
            throw new IOException("The specified folder path exists and is not a folder.");
        }
        return false;
    }

    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        return this.underlyingFs.create(f, permission, flags, bufferSize, replication, blockSize, progress, checksumOpt);
    }

    @Deprecated
    public FSDataOutputStream createNonRecursive(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.underlyingFs.createNonRecursive(f, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Deprecated
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.underlyingFs.createNonRecursive(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Deprecated
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.underlyingFs.createNonRecursive(f, permission, flags, bufferSize, replication, blockSize, progress);
    }

    public boolean createNewFile(Path f) throws IOException {
        return this.underlyingFs.createNewFile(f);
    }

    public FSDataOutputStream append(Path f) throws IOException {
        return this.underlyingFs.append(f);
    }

    public FSDataOutputStream append(Path f, int bufferSize) throws IOException {
        return this.underlyingFs.append(f, bufferSize);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.underlyingFs.create(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.underlyingFs.create(f, permission, flags, bufferSize, replication, blockSize, progress);
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        return this.underlyingFs.listStatus(f);
    }

    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        return this.underlyingFs.listCorruptFileBlocks(path);
    }

    public FileStatus[] listStatus(Path f, PathFilter filter) throws FileNotFoundException, IOException {
        return this.underlyingFs.listStatus(f, filter);
    }

    public FileStatus[] listStatus(Path[] files) throws FileNotFoundException, IOException {
        return this.underlyingFs.listStatus(files);
    }

    public FileStatus[] listStatus(Path[] files, PathFilter filter) throws FileNotFoundException, IOException {
        return this.underlyingFs.listStatus(files, filter);
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return this.underlyingFs.globStatus(pathPattern);
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        return this.underlyingFs.globStatus(pathPattern, filter);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws FileNotFoundException, IOException {
        return this.underlyingFs.listLocatedStatus(f);
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws FileNotFoundException, IOException {
        return this.underlyingFs.listFiles(f, recursive);
    }

    public Path getHomeDirectory() {
        return this.underlyingFs.getHomeDirectory();
    }

    public void setWorkingDirectory(Path new_dir) {
        this.throwUnsupported();
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.underlyingFs.rename(src, dst);
    }

    @Deprecated
    public boolean delete(Path f) throws IOException {
        return this.underlyingFs.delete(f);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.underlyingFs.delete(f, recursive);
    }

    public boolean deleteOnExit(Path f) throws IOException {
        return this.underlyingFs.deleteOnExit(f);
    }

    public boolean cancelDeleteOnExit(Path f) {
        return this.underlyingFs.cancelDeleteOnExit(f);
    }

    public boolean exists(Path f) throws IOException {
        return this.underlyingFs.exists(f);
    }

    public boolean isDirectory(Path f) throws IOException {
        return this.underlyingFs.isDirectory(f);
    }

    public boolean isFile(Path f) throws IOException {
        return this.underlyingFs.isFile(f);
    }

    @Deprecated
    public long getLength(Path f) throws IOException {
        return this.underlyingFs.getLength(f);
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        return this.underlyingFs.getContentSummary(f);
    }

    public URI getUri() {
        return this.underlyingFs.getUri();
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
    public String getCanonicalServiceName() {
        return this.underlyingFs.getCanonicalServiceName();
    }

    @Deprecated
    public String getName() {
        return this.underlyingFs.getName();
    }

    public Path makeQualified(Path path) {
        return this.underlyingFs.makeQualified(path);
    }

    @InterfaceAudience.Private
    public Token<?> getDelegationToken(String renewer) throws IOException {
        return this.underlyingFs.getDelegationToken(renewer);
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
    public Token<?>[] addDelegationTokens(String renewer, Credentials credentials) throws IOException {
        return this.underlyingFs.addDelegationTokens(renewer, credentials);
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    @VisibleForTesting
    public FileSystem[] getChildFileSystems() {
        return this.underlyingFs.getChildFileSystems();
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        return this.underlyingFs.getFileBlockLocations(file, start, len);
    }

    public BlockLocation[] getFileBlockLocations(Path p, long start, long len) throws IOException {
        return this.underlyingFs.getFileBlockLocations(p, start, len);
    }

    @Deprecated
    public FsServerDefaults getServerDefaults() throws IOException {
        return this.underlyingFs.getServerDefaults();
    }

    public FsServerDefaults getServerDefaults(Path p) throws IOException {
        return this.underlyingFs.getServerDefaults(p);
    }

    public Path resolvePath(Path p) throws IOException {
        return this.underlyingFs.resolvePath(p);
    }

    public boolean truncate(Path f, long newLength) throws IOException {
        return this.underlyingFs.truncate(f, newLength);
    }

    public RemoteIterator<FileStatus> listStatusIterator(Path p) throws FileNotFoundException, IOException {
        return this.underlyingFs.listStatusIterator(p);
    }

    public void access(Path path, FsAction mode) throws AccessControlException, FileNotFoundException, IOException {
        this.underlyingFs.access(path, mode);
    }

    public FileChecksum getFileChecksum(Path f, long length) throws IOException {
        return this.underlyingFs.getFileChecksum(f, length);
    }

    public void setXAttr(Path path, String name, byte[] value) throws IOException {
        this.underlyingFs.setXAttr(path, name, value);
    }

    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.underlyingFs.setXAttr(path, name, value, flag);
    }

    public byte[] getXAttr(Path path, String name) throws IOException {
        return this.underlyingFs.getXAttr(path, name);
    }

    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        return this.underlyingFs.getXAttrs(path);
    }

    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        return this.underlyingFs.getXAttrs(path, names);
    }

    public List<String> listXAttrs(Path path) throws IOException {
        return this.underlyingFs.listXAttrs(path);
    }

    public void removeXAttr(Path path, String name) throws IOException {
        this.underlyingFs.removeXAttr(path, name);
    }

    public InputStream openPossiblyCompressedStream(Path path) throws IOException {
        CompressionCodec codec = this.getCodec(path);
        FSDataInputStream inputStream = this.open(path);
        if (codec != null) {
            inputStream = codec.createInputStream((InputStream)inputStream);
        }
        return inputStream;
    }

    public CompressionCodec getCodec(Path path) {
        return this.codecFactory.getCodec(path);
    }

    @Override
    public void fileOpened(Path path, DrillFSDataInputStream fsDataInputStream) {
        this.openedFiles.put(fsDataInputStream, new DebugStackTrace(path, Thread.currentThread().getStackTrace()));
    }

    @Override
    public void fileClosed(DrillFSDataInputStream fsDataInputStream) {
        this.openedFiles.remove((Object)fsDataInputStream);
    }

    public static class DebugStackTrace {
        private final StackTraceElement[] elements;
        private final Path path;

        public DebugStackTrace(Path path, StackTraceElement[] elements) {
            this.path = path;
            this.elements = elements;
        }

        public void addToStringBuilder(StringBuffer sb) {
            sb.append("File '");
            sb.append(this.path.toString());
            sb.append("' opened at callstack:\n");
            for (int i = 3; i < this.elements.length; ++i) {
                sb.append("\t");
                sb.append(this.elements[i]);
                sb.append("\n");
            }
            sb.append("\n");
        }
    }
}

