/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.MetadataContext;
import org.apache.drill.exec.util.DrillFileSystemUtil;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSelection
implements DrillTableSelection {
    private static final Logger logger = LoggerFactory.getLogger(FileSelection.class);
    private static final String WILD_CARD = "*";
    private List<FileStatus> statuses;
    public List<Path> files;
    public final Path selectionRoot;
    public final Path cacheFileRoot;
    private MetadataContext metaContext = null;
    private boolean emptyDirectory;
    private StatusType dirStatus;
    private boolean hadWildcard;
    private boolean wasAllPartitionsPruned;

    public FileSelection(List<FileStatus> statuses, List<Path> files, Path selectionRoot) {
        this(statuses, files, selectionRoot, null, false, StatusType.NOT_CHECKED);
    }

    public FileSelection(List<FileStatus> statuses, List<Path> files, Path selectionRoot, Path cacheFileRoot, boolean wasAllPartitionsPruned) {
        this(statuses, files, selectionRoot, cacheFileRoot, wasAllPartitionsPruned, StatusType.NOT_CHECKED);
    }

    public FileSelection(List<FileStatus> statuses, List<Path> files, Path selectionRoot, Path cacheFileRoot, boolean wasAllPartitionsPruned, StatusType dirStatus) {
        this.statuses = statuses;
        this.files = files;
        this.selectionRoot = selectionRoot;
        this.dirStatus = dirStatus;
        this.cacheFileRoot = cacheFileRoot;
        this.wasAllPartitionsPruned = wasAllPartitionsPruned;
    }

    protected FileSelection(FileSelection selection) {
        Preconditions.checkNotNull(selection, "File selection cannot be null");
        this.statuses = selection.statuses;
        this.files = selection.files;
        this.selectionRoot = selection.selectionRoot;
        this.dirStatus = selection.dirStatus;
        this.cacheFileRoot = selection.cacheFileRoot;
        this.metaContext = selection.metaContext;
        this.hadWildcard = selection.hadWildcard;
        this.wasAllPartitionsPruned = selection.wasAllPartitionsPruned;
        this.emptyDirectory = selection.emptyDirectory;
    }

    public Path getSelectionRoot() {
        return this.selectionRoot;
    }

    public List<FileStatus> getStatuses(DrillFileSystem fs) throws IOException {
        Stopwatch timer;
        Stopwatch stopwatch = timer = logger.isDebugEnabled() ? Stopwatch.createStarted() : null;
        if (this.statuses == null) {
            ArrayList<FileStatus> newStatuses = new ArrayList<FileStatus>();
            for (Path pathStr : Objects.requireNonNull(this.files, "Files can not be null if statuses are null")) {
                newStatuses.add(fs.getFileStatus(pathStr));
            }
            this.statuses = newStatuses;
        }
        if (timer != null) {
            logger.debug("FileSelection.getStatuses() took {} ms, numFiles: {}", (Object)timer.elapsed(TimeUnit.MILLISECONDS), (Object)(this.statuses == null ? 0 : this.statuses.size()));
            timer.stop();
        }
        return this.statuses;
    }

    public List<Path> getFiles() {
        if (this.files == null) {
            this.files = Objects.requireNonNull(this.statuses, "Statuses can not be null if files are null").stream().map(FileStatus::getPath).collect(Collectors.toList());
        }
        return this.files;
    }

    public boolean containsDirectories(DrillFileSystem fs) throws IOException {
        if (this.dirStatus == StatusType.NOT_CHECKED) {
            this.dirStatus = StatusType.NO_DIRS;
            for (FileStatus status : this.getStatuses(fs)) {
                if (!status.isDirectory()) continue;
                this.dirStatus = StatusType.HAS_DIRS;
                break;
            }
        }
        return this.dirStatus == StatusType.HAS_DIRS;
    }

    public FileSelection minusDirectories(DrillFileSystem fs) throws IOException {
        if (this.isExpandedFully()) {
            return this;
        }
        Stopwatch timer = logger.isDebugEnabled() ? Stopwatch.createStarted() : null;
        List<FileStatus> statuses = this.getStatuses(fs);
        ArrayList<FileStatus> nonDirectories = Lists.newArrayList();
        for (FileStatus status : statuses) {
            nonDirectories.addAll(DrillFileSystemUtil.listFiles(fs, status.getPath(), true, new PathFilter[0]));
        }
        FileSelection fileSel = FileSelection.create(nonDirectories, null, this.selectionRoot);
        if (timer != null) {
            logger.debug("FileSelection.minusDirectories() took {} ms, numFiles: {}", (Object)timer.elapsed(TimeUnit.MILLISECONDS), (Object)statuses.size());
            timer.stop();
        }
        if (fileSel != null) {
            fileSel.setExpandedFully();
        }
        return fileSel;
    }

    public FileSelection selectAnyFile(DrillFileSystem fs) throws IOException {
        List<FileStatus> statuses = this.getStatuses(fs);
        ArrayList<FileStatus> anyFile = Lists.newArrayList();
        for (FileStatus status : statuses) {
            anyFile.addAll(DrillFileSystemUtil.anyFile(fs, status.getPath(), new PathFilter[0]));
            if (anyFile.size() <= 0) continue;
            break;
        }
        return FileSelection.create(anyFile, null, this.selectionRoot);
    }

    public FileStatus getFirstPath(DrillFileSystem fs) throws IOException {
        return this.getStatuses(fs).get(0);
    }

    public void setExpandedFully() {
        this.dirStatus = StatusType.EXPANDED_FULLY;
    }

    public boolean isExpandedFully() {
        return this.dirStatus == StatusType.EXPANDED_FULLY;
    }

    public void setExpandedPartial() {
        this.dirStatus = StatusType.EXPANDED_PARTIAL;
    }

    public boolean isExpandedPartial() {
        return this.dirStatus == StatusType.EXPANDED_PARTIAL;
    }

    public StatusType getDirStatus() {
        return this.dirStatus;
    }

    public boolean wasAllPartitionsPruned() {
        return this.wasAllPartitionsPruned;
    }

    private static Path commonPathForFiles(List<Path> files) {
        int latest;
        if (files == null || files.isEmpty()) {
            return new Path("/");
        }
        int total = files.size();
        String[][] folders = new String[total][];
        int shortest = Integer.MAX_VALUE;
        for (int i = 0; i < total; ++i) {
            folders[i] = files.get(i).toUri().getPath().split("/");
            shortest = Math.min(shortest, folders[i].length);
        }
        block1: for (latest = 0; latest < shortest; ++latest) {
            String current = folders[0][latest];
            for (int i = 1; i < folders.length; ++i) {
                if (!current.equals(folders[i][latest])) break block1;
            }
        }
        URI uri = files.get(0).toUri();
        String pathString = FileSelection.buildPath(folders[0], latest);
        return new Path(uri.getScheme(), uri.getAuthority(), pathString);
    }

    private static String buildPath(String[] path, int folderIndex) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < folderIndex; ++i) {
            builder.append(path[i]).append("/");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static FileSelection create(DrillFileSystem fs, String parent, String path, boolean allowAccessOutsideWorkspace) throws IOException {
        FileStatus[] statuses;
        Stopwatch timer = logger.isDebugEnabled() ? Stopwatch.createStarted() : null;
        boolean hasWildcard = path.contains(WILD_CARD);
        String child = DrillStringUtils.removeLeadingSlash(path);
        Path combined = new Path(parent, child);
        Path root = new Path(parent, DrillStringUtils.unescapeJava(child));
        if (!allowAccessOutsideWorkspace) {
            FileSelection.checkBackPaths(new Path(parent).toUri().getPath(), combined.toUri().getPath(), path);
        }
        if ((statuses = fs.globStatus(combined)) == null) {
            return null;
        }
        FileSelection fileSel = FileSelection.create(Arrays.asList(statuses), null, root);
        if (timer != null) {
            logger.debug("FileSelection.create() took {} ms ", (Object)timer.elapsed(TimeUnit.MILLISECONDS));
            timer.stop();
        }
        if (fileSel == null) {
            return null;
        }
        fileSel.setHadWildcard(hasWildcard);
        return fileSel;
    }

    public static FileSelection create(List<FileStatus> statuses, List<Path> files, Path root, Path cacheFileRoot, boolean wasAllPartitionsPruned) {
        Path selectionRoot;
        boolean bothEmptySelection;
        boolean bothNonEmptySelection = statuses != null && statuses.size() > 0 && files != null && files.size() > 0;
        boolean bl = bothEmptySelection = !(statuses != null && statuses.size() != 0 || files != null && files.size() != 0);
        if (bothNonEmptySelection || bothEmptySelection) {
            return null;
        }
        if (statuses == null || statuses.isEmpty()) {
            selectionRoot = FileSelection.commonPathForFiles(files);
        } else {
            Objects.requireNonNull(root, "Selection root is null");
            Path rootPath = FileSelection.handleWildCard(root);
            URI uri = statuses.get(0).getPath().toUri();
            selectionRoot = new Path(uri.getScheme(), uri.getAuthority(), rootPath.toUri().getPath());
        }
        return new FileSelection(statuses, files, selectionRoot, cacheFileRoot, wasAllPartitionsPruned);
    }

    public static FileSelection create(List<FileStatus> statuses, List<Path> files, Path root) {
        return FileSelection.create(statuses, files, root, null, false);
    }

    public static FileSelection createFromDirectories(List<Path> dirPaths, FileSelection selection, Path cacheFileRoot) {
        Stopwatch timer = logger.isDebugEnabled() ? Stopwatch.createStarted() : null;
        Path root = selection.getSelectionRoot();
        Objects.requireNonNull(root, "Selection root is null");
        if (dirPaths == null || dirPaths.isEmpty()) {
            throw new DrillRuntimeException("List of directories is null or empty");
        }
        ArrayList<Path> dirs = selection.hadWildcard() ? selection.getFileStatuses().stream().map(FileStatus::getPath).collect(Collectors.toList()) : new ArrayList<Path>(dirPaths);
        Path rootPath = FileSelection.handleWildCard(root);
        URI uri = selection.getFileStatuses().get(0).getPath().toUri();
        Path path = new Path(uri.getScheme(), uri.getAuthority(), rootPath.toUri().getPath());
        FileSelection fileSel = new FileSelection(null, dirs, path, cacheFileRoot, false);
        fileSel.setHadWildcard(selection.hadWildcard());
        if (timer != null) {
            logger.debug("FileSelection.createFromDirectories() took {} ms ", (Object)timer.elapsed(TimeUnit.MILLISECONDS));
            timer.stop();
        }
        return fileSel;
    }

    private static Path handleWildCard(Path root) {
        String stringRoot = root.toUri().getPath();
        if (stringRoot.contains(WILD_CARD)) {
            int idx = stringRoot.indexOf(WILD_CARD);
            idx = stringRoot.lastIndexOf(47, idx);
            String newRoot = stringRoot.substring(0, idx);
            return DrillFileSystemUtil.createPathSafe(newRoot);
        }
        return new Path(stringRoot);
    }

    public static void checkBackPaths(String parent, String combinedPath, String subpath) {
        Preconditions.checkArgument(!parent.isEmpty(), "Invalid root (" + parent + ") in file selection path.");
        Preconditions.checkArgument(!combinedPath.isEmpty(), "Empty path (" + combinedPath + "( in file selection path.");
        if (!combinedPath.startsWith(parent)) {
            throw new IllegalArgumentException(String.format("Invalid path [%s] takes you outside the workspace.", subpath));
        }
    }

    public List<FileStatus> getFileStatuses() {
        return this.statuses;
    }

    public boolean supportsDirPruning() {
        return (this.isExpandedFully() || this.isExpandedPartial()) && !this.wasAllPartitionsPruned;
    }

    public void setHadWildcard(boolean wc) {
        this.hadWildcard = wc;
    }

    public boolean hadWildcard() {
        return this.hadWildcard;
    }

    public Path getCacheFileRoot() {
        return this.cacheFileRoot;
    }

    public void setMetaContext(MetadataContext context) {
        this.metaContext = context;
    }

    public MetadataContext getMetaContext() {
        return this.metaContext;
    }

    public boolean isEmptyDirectory() {
        return this.emptyDirectory;
    }

    public void setEmptyDirectoryStatus() {
        this.emptyDirectory = true;
    }

    @Override
    public String digest() {
        return this.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("root=").append(this.selectionRoot);
        sb.append("files=[");
        sb.append(this.getFiles().stream().map(Path::toString).collect(Collectors.joining(", ")));
        sb.append("]");
        return sb.toString();
    }

    private static enum StatusType {
        NOT_CHECKED,
        NO_DIRS,
        HAS_DIRS,
        EXPANDED_FULLY,
        EXPANDED_PARTIAL;

    }
}

