/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.commons.io.IOUtils;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.exec.metastore.MetadataProviderManager;
import org.apache.drill.exec.oauth.OAuthTokenProvider;
import org.apache.drill.exec.oauth.PersistentTokenTable;
import org.apache.drill.exec.oauth.TokenRegistry;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.planner.PlannerPhase;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.options.SessionOptionManager;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.ClassPathFileSystem;
import org.apache.drill.exec.store.LocalSyncableFileSystem;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.dfs.BoxFileSystem;
import org.apache.drill.exec.store.dfs.DropboxFileSystem;
import org.apache.drill.exec.store.dfs.FileSystemConfig;
import org.apache.drill.exec.store.dfs.FileSystemSchemaFactory;
import org.apache.drill.exec.store.dfs.FormatCreator;
import org.apache.drill.exec.store.dfs.FormatMatcher;
import org.apache.drill.exec.store.dfs.FormatPlugin;
import org.apache.drill.exec.store.dfs.FormatSelection;
import org.apache.drill.exec.store.dfs.NamedFormatPluginConfig;
import org.apache.drill.exec.store.dfs.WorkspaceConfig;
import org.apache.drill.exec.store.dfs.WorkspaceSchemaFactory;
import org.apache.drill.exec.store.dfs.ZipCodec;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemPlugin
extends AbstractStoragePlugin {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemPlugin.class);
    private static final List<String> ADDITIONAL_CODECS = Collections.singletonList(ZipCodec.class.getCanonicalName());
    private final FileSystemSchemaFactory schemaFactory;
    private final FormatCreator formatCreator;
    private final Map<FormatPluginConfig, FormatPlugin> formatPluginsByConfig;
    private final FileSystemConfig config;
    private final Configuration fsConf;
    private TokenRegistry tokenRegistry;
    private final boolean mountCommandsEnabled;

    public FileSystemPlugin(FileSystemConfig config, DrillbitContext context, String name) throws ExecutionSetupException {
        super(context, name);
        this.config = config;
        try {
            this.fsConf = new Configuration();
            Optional.ofNullable(config.getConfig()).ifPresent(c -> c.forEach((arg_0, arg_1) -> ((Configuration)this.fsConf).set(arg_0, arg_1)));
            this.fsConf.set("fs.defaultFS", config.getConnection());
            this.fsConf.set("fs.classpath.impl", ClassPathFileSystem.class.getName());
            this.fsConf.set("fs.dropbox.impl", DropboxFileSystem.class.getName());
            this.fsConf.set("fs.box.impl", BoxFileSystem.class.getName());
            this.fsConf.set("fs.drill-local.impl", LocalSyncableFileSystem.class.getName());
            CredentialsProvider credentialsProvider = config.getCredentialsProvider();
            if (credentialsProvider != null) {
                credentialsProvider.getCredentials().forEach((arg_0, arg_1) -> ((Configuration)this.fsConf).set(arg_0, arg_1));
            }
            this.addCodecs(this.fsConf);
            if (this.isS3Connection(this.fsConf)) {
                this.handleS3Credentials(this.fsConf);
            } else if (config.oAuthConfig() != null && config.getAuthMode() == StoragePluginConfig.AuthMode.SHARED_USER) {
                this.initializeOauthTokenTable(null);
            }
            this.formatCreator = this.newFormatCreator(config, context, this.fsConf);
            ArrayList<FormatMatcher> matchers = new ArrayList<FormatMatcher>();
            this.formatPluginsByConfig = new HashMap<FormatPluginConfig, FormatPlugin>();
            for (FormatPlugin p : this.formatCreator.getConfiguredFormatPlugins()) {
                matchers.add(p.getMatcher());
                this.formatPluginsByConfig.put(p.getConfig(), p);
            }
            matchers.sort(Comparator.comparing(FormatMatcher::priority).reversed());
            boolean noWorkspace = config.getWorkspaces() == null || config.getWorkspaces().isEmpty();
            ArrayList<WorkspaceSchemaFactory> factories = new ArrayList<WorkspaceSchemaFactory>();
            if (!noWorkspace) {
                for (Map.Entry<String, WorkspaceConfig> space : config.getWorkspaces().entrySet()) {
                    factories.add(new WorkspaceSchemaFactory(this, space.getKey(), name, space.getValue(), matchers, context.getLpPersistence().getMapper(), context.getClasspathScan()));
                }
            }
            if (noWorkspace || !config.getWorkspaces().containsKey("default")) {
                factories.add(new WorkspaceSchemaFactory(this, "default", name, WorkspaceConfig.DEFAULT, matchers, context.getLpPersistence().getMapper(), context.getClasspathScan()));
            }
            this.schemaFactory = new FileSystemSchemaFactory(name, factories);
            this.mountCommandsEnabled = context.getConfig().getBoolean("drill.exec.storage.file.enable_mount_commands");
        }
        catch (IOException e) {
            throw new ExecutionSetupException("Failure setting up file system plugin.", e);
        }
    }

    private void addCodecs(Configuration conf) {
        String confCodecs = conf.get("io.compression.codecs");
        String builtInCodecs = String.join((CharSequence)",", ADDITIONAL_CODECS);
        String newCodecs = Strings.isNullOrEmpty(confCodecs) ? builtInCodecs : builtInCodecs + ", " + confCodecs;
        logger.trace("Codecs: {}", (Object)newCodecs);
        conf.set("io.compression.codecs", newCodecs);
    }

    private boolean isS3Connection(Configuration conf) {
        URI uri = FileSystem.getDefaultUri((Configuration)conf);
        return uri.getScheme().equals("s3a");
    }

    private void handleS3Credentials(Configuration conf) throws IOException {
        String[] credentialKeys;
        for (String key : credentialKeys = new String[]{"fs.s3a.secret.key", "fs.s3a.access.key"}) {
            char[] credentialChars = conf.getPassword(key);
            if (credentialChars == null) {
                logger.warn("Property '{}' is absent.", (Object)key);
                continue;
            }
            conf.set(key, String.valueOf(credentialChars));
        }
    }

    @VisibleForTesting
    public void initializeOauthTokenTable(String username) {
        OAuthTokenProvider tokenProvider = this.context.getOauthTokenProvider();
        this.tokenRegistry = tokenProvider.getOauthTokenRegistry(username);
        this.tokenRegistry.createTokenTable(this.getName());
    }

    public TokenRegistry getTokenRegistry() {
        return this.tokenRegistry;
    }

    @VisibleForTesting
    public TokenRegistry getTokenRegistry(String username) {
        this.initializeOauthTokenTable(username);
        return this.tokenRegistry;
    }

    public PersistentTokenTable getTokenTable() {
        return this.tokenRegistry.getTokenTable(this.getName());
    }

    protected FormatCreator newFormatCreator(FileSystemConfig config, DrillbitContext context, Configuration fsConf) {
        return new FormatCreator(context, fsConf, config);
    }

    @Override
    public boolean supportsRead() {
        return true;
    }

    @Override
    public StoragePluginConfig getConfig() {
        return this.config;
    }

    @Override
    public AbstractGroupScan getPhysicalScan(String userName, JSONOptions selection, SessionOptionManager options) throws IOException {
        return this.getPhysicalScan(userName, selection, AbstractGroupScan.ALL_COLUMNS, options, null);
    }

    @Override
    public AbstractGroupScan getPhysicalScan(String userName, JSONOptions selection, SessionOptionManager options, MetadataProviderManager metadataProviderManager) throws IOException {
        return this.getPhysicalScan(userName, selection, AbstractGroupScan.ALL_COLUMNS, options, metadataProviderManager);
    }

    @Override
    public AbstractGroupScan getPhysicalScan(String userName, JSONOptions selection, List<SchemaPath> columns) throws IOException {
        return this.getPhysicalScan(userName, selection, columns, null, null);
    }

    @Override
    public AbstractGroupScan getPhysicalScan(String userName, JSONOptions selection, List<SchemaPath> columns, SessionOptionManager options, MetadataProviderManager metadataProviderManager) throws IOException {
        FormatSelection formatSelection = selection.getWith(this.context.getLpPersistence().getMapper(), FormatSelection.class);
        FormatPlugin plugin = this.getFormatPlugin(formatSelection.getFormat());
        return plugin.getGroupScan(userName, formatSelection.getSelection(), columns, options, metadataProviderManager);
    }

    @Override
    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) throws IOException {
        if (this.config.getAuthMode() == StoragePluginConfig.AuthMode.USER_TRANSLATION) {
            this.initializeOauthTokenTable(schemaConfig.getUserName());
        }
        this.schemaFactory.registerSchemas(schemaConfig, parent);
    }

    public FormatPlugin getFormatPlugin(String name) {
        return this.formatCreator.getFormatPluginByName(name);
    }

    @Override
    public FormatPlugin getFormatPlugin(FormatPluginConfig config) {
        if (config instanceof NamedFormatPluginConfig) {
            return this.formatCreator.getFormatPluginByName(((NamedFormatPluginConfig)config).getName());
        }
        FormatPlugin plugin = this.formatPluginsByConfig.get(config);
        if (plugin == null) {
            plugin = this.formatCreator.newFormatPlugin(config);
        }
        return plugin;
    }

    @Override
    public Set<? extends RelOptRule> getOptimizerRules(OptimizerRulesContext optimizerContext, PlannerPhase phase) {
        return this.formatCreator.getConfiguredFormatPlugins().stream().map(plugin -> plugin.getOptimizerRules(phase)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Configuration getFsConf() {
        return new Configuration(this.fsConf);
    }

    @VisibleForTesting
    public void initializeTokenTableForTesting() {
        OAuthTokenProvider tokenProvider = this.context.getOauthTokenProvider();
        this.tokenRegistry = tokenProvider.getOauthTokenRegistry(null);
    }

    private synchronized boolean mount() {
        List<String> mountCmd = this.config.getMountCommand();
        if (mountCmd == null || mountCmd.isEmpty()) {
            return false;
        }
        if (!this.mountCommandsEnabled) {
            throw UserException.permissionError().message("A mount command has been configured but mount commands are disabled, see %s", "drill.exec.storage.file.enable_mount_commands").build(logger);
        }
        try {
            Process proc = Runtime.getRuntime().exec(mountCmd.toArray(new String[0]));
            if (proc.waitFor() != 0) {
                String stderrOutput = IOUtils.toString((InputStream)proc.getErrorStream(), (Charset)StandardCharsets.UTF_8);
                throw new IOException(stderrOutput);
            }
            logger.info("The mount command for plugin {} succeeded.", (Object)this.getName());
            return true;
        }
        catch (IOException | InterruptedException e) {
            logger.error("The mount command for plugin {} failed.", (Object)this.getName(), (Object)e);
            throw UserException.pluginError(e).message("The mount command for plugin %s failed.", this.getName()).build(logger);
        }
    }

    private synchronized boolean unmount() {
        List<String> unmountCmd = this.config.getUnmountCommand();
        if (unmountCmd == null || unmountCmd.isEmpty()) {
            return false;
        }
        if (!this.mountCommandsEnabled) {
            throw UserException.permissionError().message("A mount command has been configured but mount commands are disabled, see %s", "drill.exec.storage.file.enable_mount_commands").build(logger);
        }
        try {
            Process proc = Runtime.getRuntime().exec(unmountCmd.toArray(new String[0]));
            if (proc.waitFor() != 0) {
                String stderrOutput = IOUtils.toString((InputStream)proc.getErrorStream(), (Charset)StandardCharsets.UTF_8);
                throw new IOException(stderrOutput);
            }
            logger.info("The unmount command for plugin {} succeeded.", (Object)this.getName());
            return true;
        }
        catch (IOException | InterruptedException e) {
            logger.error("The unmount command for plugin {} failed.", (Object)this.getName(), (Object)e);
            throw UserException.pluginError(e).message("The unmount command for plugin %s failed.", this.getName()).build(logger);
        }
    }

    @Override
    public void start() {
        if (this.config.isEnabled()) {
            this.mount();
        }
    }

    @Override
    public void onEnabled() {
        this.mount();
    }

    @Override
    public void onDisabled() {
        this.unmount();
    }

    @Override
    public void close() {
        boolean isEnabled;
        boolean bl = isEnabled = this.getContext().getStorage().getDefinedConfig(this.getName()) != null;
        if (isEnabled) {
            this.unmount();
        }
    }
}

