/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.util.ConstructorChecker;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.dfs.FileSystemConfig;
import org.apache.drill.exec.store.dfs.FormatPlugin;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatCreator {
    private static final Logger logger = LoggerFactory.getLogger(FormatCreator.class);
    private static final ConstructorChecker FORMAT_BASED = new ConstructorChecker(String.class, DrillbitContext.class, Configuration.class, StoragePluginConfig.class, FormatPluginConfig.class);
    private static final ConstructorChecker DEFAULT_BASED = new ConstructorChecker(String.class, DrillbitContext.class, Configuration.class, StoragePluginConfig.class);
    private final DrillbitContext context;
    private final Configuration fsConf;
    private final FileSystemConfig storageConfig;
    private final Map<String, FormatPlugin> configuredPlugins;
    private final Collection<Class<? extends FormatPlugin>> pluginClasses;
    private final Map<Class<?>, Constructor<?>> configConstructors;

    private static Map<Class<?>, Constructor<?>> initConfigConstructors(Collection<Class<? extends FormatPlugin>> pluginClasses) {
        HashMap constructors = new HashMap();
        for (Class<? extends FormatPlugin> pluginClass : pluginClasses) {
            for (Constructor<?> c : pluginClass.getConstructors()) {
                try {
                    if (!FORMAT_BASED.check(c)) continue;
                    Class<?> configClass = c.getParameterTypes()[4];
                    constructors.put(configClass, c);
                }
                catch (Exception e) {
                    logger.warn(String.format("Failure while trying instantiate FormatPlugin %s.", pluginClass.getName()), (Throwable)e);
                }
            }
        }
        return constructors;
    }

    FormatCreator(DrillbitContext context, Configuration fsConf, FileSystemConfig storageConfig) {
        this.context = context;
        this.fsConf = fsConf;
        this.storageConfig = storageConfig;
        this.pluginClasses = context.getClasspathScan().getImplementations(FormatPlugin.class);
        this.configConstructors = FormatCreator.initConfigConstructors(this.pluginClasses);
        HashMap<String, FormatPlugin> plugins = new HashMap<String, FormatPlugin>();
        if (storageConfig.getFormats() == null || storageConfig.getFormats().isEmpty()) {
            for (Class<? extends FormatPlugin> pluginClass : this.pluginClasses) {
                for (Constructor<?> c : pluginClass.getConstructors()) {
                    try {
                        if (!DEFAULT_BASED.check(c)) continue;
                        FormatPlugin plugin = (FormatPlugin)c.newInstance(null, context, fsConf, storageConfig);
                        plugins.put(plugin.getName(), plugin);
                    }
                    catch (Exception e) {
                        logger.warn(String.format("Failure while trying instantiate FormatPlugin %s.", pluginClass.getName()), (Throwable)e);
                    }
                }
            }
        } else {
            for (Map.Entry<String, FormatPluginConfig> e : storageConfig.getFormats().entrySet()) {
                Constructor<?> c = this.configConstructors.get(e.getValue().getClass());
                if (c == null) {
                    logger.warn("Unable to find constructor for storage config named '{}' of type '{}'.", (Object)e.getKey(), (Object)e.getValue().getClass().getName());
                    continue;
                }
                try {
                    plugins.put(e.getKey(), (FormatPlugin)c.newInstance(e.getKey(), context, fsConf, storageConfig, e.getValue()));
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e1) {
                    logger.warn("Failure initializing storage config named '{}' of type '{}'.", new Object[]{e.getKey(), e.getValue().getClass().getName(), e1});
                }
            }
        }
        this.configuredPlugins = Collections.unmodifiableMap(plugins);
    }

    FormatPlugin getFormatPluginByName(String name) {
        return this.configuredPlugins.get(name);
    }

    Collection<FormatPlugin> getConfiguredFormatPlugins() {
        return this.configuredPlugins.values();
    }

    FormatPlugin newFormatPlugin(FormatPluginConfig fpconfig) {
        Constructor<?> c = this.configConstructors.get(fpconfig.getClass());
        if (c == null) {
            throw UserException.dataReadError().message("Unable to find constructor for storage config of type %s", fpconfig.getClass().getName()).build(logger);
        }
        try {
            return (FormatPlugin)c.newInstance(null, this.context, this.fsConf, this.storageConfig, fpconfig);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw UserException.dataReadError(e).message("Failure initializing storage config of type %s", fpconfig.getClass().getName()).build(logger);
        }
    }
}

