/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.exec.store.dfs.WorkspaceSchemaFactory;
import org.apache.drill.exec.store.table.function.TableParamDef;
import org.apache.drill.exec.store.table.function.TableSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FormatPluginOptionsDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(FormatPluginOptionsDescriptor.class);
    protected final Class<? extends FormatPluginConfig> pluginConfigClass;
    protected final String typeName;
    private final Map<String, TableParamDef> functionParamsByName;

    FormatPluginOptionsDescriptor(Class<? extends FormatPluginConfig> pluginConfigClass) {
        this.pluginConfigClass = pluginConfigClass;
        LinkedHashMap<String, TableParamDef> paramsByName = new LinkedHashMap<String, TableParamDef>();
        Field[] fields = pluginConfigClass.getDeclaredFields();
        JsonTypeName annotation = pluginConfigClass.getAnnotation(JsonTypeName.class);
        String string = this.typeName = annotation != null ? annotation.value() : null;
        if (this.typeName != null) {
            paramsByName.put("type", TableParamDef.required("type", String.class, null));
        }
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers()) || field.getName().equals("extensions") && field.getType() == List.class) continue;
            Class<Object> fieldType = field.getType();
            if (fieldType == Character.TYPE) {
                fieldType = String.class;
            }
            paramsByName.put(field.getName(), TableParamDef.optional(field.getName(), fieldType, null));
        }
        this.functionParamsByName = Collections.unmodifiableMap(paramsByName);
    }

    public String getTypeName() {
        return this.typeName;
    }

    protected TableSignature getTableSignature(String tableName, List<TableParamDef> tableParameters) {
        return TableSignature.of(tableName, tableParameters, this.params());
    }

    private List<TableParamDef> params() {
        return new ArrayList<TableParamDef>(this.functionParamsByName.values());
    }

    protected String presentParams() {
        StringBuilder sb = new StringBuilder("(");
        List<TableParamDef> params = this.params();
        for (int i = 0; i < params.size(); ++i) {
            TableParamDef paramDef = params.get(i);
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(paramDef.getName()).append(": ").append(paramDef.getType().getSimpleName());
        }
        sb.append(")");
        return sb.toString();
    }

    FormatPluginConfig createConfigForTable(WorkspaceSchemaFactory.TableInstance t, ObjectMapper mapper, FormatPluginConfig baseConfig) {
        ConfigCreator configCreator = new ConfigCreator(t, mapper, baseConfig);
        return configCreator.createNewStyle();
    }

    public String toString() {
        return "OptionsDescriptor [pluginConfigClass=" + this.pluginConfigClass + ", typeName=" + this.typeName + ", functionParamsByName=" + this.functionParamsByName + "]";
    }

    private class ConfigCreator {
        final WorkspaceSchemaFactory.TableInstance t;
        final FormatPluginConfig baseConfig;
        final List<TableParamDef> formatParams;
        final List<Object> formatParamsValues;
        final ObjectMapper mapper;

        public ConfigCreator(WorkspaceSchemaFactory.TableInstance table, ObjectMapper mapper, FormatPluginConfig baseConfig) {
            this.t = table;
            this.mapper = mapper;
            this.baseConfig = baseConfig == null || baseConfig.getClass() != FormatPluginOptionsDescriptor.this.pluginConfigClass ? null : baseConfig;
            this.formatParams = this.t.sig.getSpecificParams();
            this.formatParamsValues = this.t.params.subList(0, this.t.params.size() - this.t.sig.getCommonParams().size());
        }

        public FormatPluginConfig createNewStyle() {
            this.verifyType();
            ObjectNode configObject = this.makeConfigNode();
            this.applyParams(configObject);
            return this.nodeToConfig(configObject);
        }

        private ObjectNode makeConfigNode() {
            if (this.baseConfig == null) {
                ObjectNode configObject = this.mapper.createObjectNode();
                configObject.replace("type", (JsonNode)this.mapper.convertValue((Object)FormatPluginOptionsDescriptor.this.typeName, JsonNode.class));
                return configObject;
            }
            return (ObjectNode)this.mapper.valueToTree((Object)this.baseConfig);
        }

        private void applyParams(ObjectNode configObject) {
            for (int i = 1; i < this.formatParamsValues.size(); ++i) {
                this.applyParam(configObject, i);
            }
        }

        private void applyParam(ObjectNode configObject, int i) {
            Object param = this.paramValue(i);
            if (param != null) {
                configObject.replace(this.formatParams.get(i).getName(), (JsonNode)this.mapper.convertValue(param, JsonNode.class));
            }
        }

        private Object paramValue(int i) {
            Object param = this.formatParamsValues.get(i);
            if (param != null && param instanceof String) {
                param = StringEscapeUtils.unescapeJava((String)((String)param));
            }
            return param;
        }

        private FormatPluginConfig nodeToConfig(ObjectNode configObject) {
            try {
                return (FormatPluginConfig)this.mapper.readerFor(FormatPluginOptionsDescriptor.this.pluginConfigClass).readValue((JsonNode)configObject);
            }
            catch (IOException e) {
                String jsonConfig;
                try {
                    jsonConfig = this.mapper.writeValueAsString((Object)configObject);
                }
                catch (JsonProcessingException e1) {
                    jsonConfig = "unavailable: " + e1.getMessage();
                }
                throw UserException.parseError(e).message("configuration for format of type %s can not be created (class: %s)", FormatPluginOptionsDescriptor.this.typeName, FormatPluginOptionsDescriptor.this.pluginConfigClass.getName()).addContext("table", this.t.sig.getName()).addContext("JSON configuration", jsonConfig).build(logger);
            }
        }

        public FormatPluginConfig createOldStyle() {
            this.verifyType();
            FormatPluginConfig config = this.configInstance();
            this.bindParams(config);
            return config;
        }

        public void verifyType() {
            TableParamDef typeParamDef = this.formatParams.get(0);
            Object typeParam = this.formatParamsValues.get(0);
            if (!(typeParamDef.getName().equals("type") && typeParamDef.getType() == String.class && typeParam instanceof String && FormatPluginOptionsDescriptor.this.typeName.equalsIgnoreCase((String)typeParam))) {
                throw UserException.parseError().message("This function signature is not supported: %s\nexpecting %s", this.t.presentParams(), FormatPluginOptionsDescriptor.this.presentParams()).addContext("table", this.t.sig.getName()).build(logger);
            }
        }

        public FormatPluginConfig configInstance() {
            try {
                return FormatPluginOptionsDescriptor.this.pluginConfigClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw UserException.parseError(e).message("configuration for format of type %s can not be created (class: %s)", FormatPluginOptionsDescriptor.this.typeName, FormatPluginOptionsDescriptor.this.pluginConfigClass.getName()).addContext("table", this.t.sig.getName()).build(logger);
            }
        }

        private void bindParams(FormatPluginConfig config) {
            for (int i = 1; i < this.formatParamsValues.size(); ++i) {
                this.bindParam(config, i);
            }
        }

        private void bindParam(FormatPluginConfig config, int i) {
            Object param = this.paramValue(i);
            if (param == null) {
                return;
            }
            TableParamDef paramDef = this.formatParams.get(i);
            TableParamDef expectedParamDef = (TableParamDef)FormatPluginOptionsDescriptor.this.functionParamsByName.get(paramDef.getName());
            if (expectedParamDef == null || expectedParamDef.getType() != paramDef.getType()) {
                throw UserException.parseError().message("The parameters provided are not applicable to the type specified:\nprovided: %s\nexpected: %s", this.t.presentParams(), FormatPluginOptionsDescriptor.this.presentParams()).addContext("table", this.t.sig.getName()).build(logger);
            }
            try {
                Field field = FormatPluginOptionsDescriptor.this.pluginConfigClass.getField(paramDef.getName());
                field.setAccessible(true);
                if (field.getType() == Character.TYPE && param instanceof String) {
                    String stringParam = (String)param;
                    if (stringParam.length() != 1) {
                        throw UserException.parseError().message("Expected single character but was String: %s", stringParam).addContext("Table", this.t.sig.getName()).addContext("Parameter", paramDef.getName()).build(logger);
                    }
                    param = Character.valueOf(stringParam.charAt(0));
                }
                field.set(config, param);
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
                throw UserException.parseError(e).message("Can not set value %s to parameter %s: %s", param, paramDef.getName(), paramDef.getType()).addContext("Table", this.t.sig.getName()).addContext("Parameter", paramDef.getName()).build(logger);
            }
        }
    }
}

