/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import java.util.List;
import java.util.Map;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.apache.hadoop.fs.Path;

public class MetadataContext {
    private Map<Path, Boolean> dirModifCheckMap = Maps.newHashMap();
    private PruneStatus pruneStatus = PruneStatus.NOT_STARTED;
    private boolean metadataCacheCorrupted;
    private List<Path> directories;

    public void setStatus(Path dir) {
        this.dirModifCheckMap.put(dir, true);
    }

    public void clearStatus(Path dir) {
        this.dirModifCheckMap.put(dir, false);
    }

    public boolean getStatus(Path dir) {
        if (this.dirModifCheckMap.containsKey(dir)) {
            return this.dirModifCheckMap.get(dir);
        }
        return false;
    }

    public void clear() {
        this.dirModifCheckMap.clear();
        this.metadataCacheCorrupted = false;
    }

    public void setPruneStatus(PruneStatus status) {
        this.pruneStatus = status;
    }

    public PruneStatus getPruneStatus() {
        return this.pruneStatus;
    }

    public boolean isMetadataCacheCorrupted() {
        return this.metadataCacheCorrupted;
    }

    public void setMetadataCacheCorrupted(boolean metadataCacheCorrupted) {
        this.metadataCacheCorrupted = metadataCacheCorrupted;
    }

    public void setDirectories(List<Path> directories) {
        this.directories = directories;
    }

    public List<Path> getDirectories() {
        return this.directories;
    }

    public static enum PruneStatus {
        NOT_STARTED,
        PRUNED,
        NOT_PRUNED;

    }
}

