/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;

public class SeekableByteArrayInputStream
extends ByteArrayInputStream
implements Seekable,
PositionedReadable {
    public SeekableByteArrayInputStream(byte[] buf) {
        super(buf);
    }

    public long getPos() throws IOException {
        return this.pos;
    }

    public void seek(long pos) throws IOException {
        if (this.mark != 0) {
            throw new IllegalStateException();
        }
        this.reset();
        long skipped = this.skip(pos);
        if (skipped != pos) {
            throw new IOException();
        }
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        if (position >= (long)this.buf.length) {
            throw new IllegalArgumentException();
        }
        if (position + (long)length > (long)this.buf.length) {
            throw new IllegalArgumentException();
        }
        if (length > buffer.length) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(this.buf, (int)position, buffer, offset, length);
        return length;
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.read(position, buffer, 0, buffer.length);
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        this.read(position, buffer, offset, length);
    }
}

