/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs.easy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.ScanBatch;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.drill.exec.store.RecordReader;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.easy.EasyFormatPlugin;
import org.apache.drill.exec.store.dfs.easy.EasySubScan;
import org.apache.drill.exec.store.dfs.easy.FileWork;
import org.apache.drill.shaded.guava.com.google.common.base.Functions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;

public class ClassicScanBuilder {
    private final FragmentContext context;
    private EasySubScan scan;
    private final EasyFormatPlugin<? extends FormatPluginConfig> plugin;

    public ClassicScanBuilder(FragmentContext context, EasySubScan scan, EasyFormatPlugin<? extends FormatPluginConfig> plugin) {
        this.context = context;
        this.scan = scan;
        this.plugin = plugin;
    }

    public CloseableRecordBatch build() throws ExecutionSetupException {
        DrillFileSystem dfs;
        ColumnExplorer columnExplorer = new ColumnExplorer(this.context.getOptions(), this.scan.getColumns());
        if (!columnExplorer.isStarQuery()) {
            this.scan = new EasySubScan(this.scan.getUserName(), this.scan.getWorkUnits(), this.scan.getFormatPlugin(), columnExplorer.getTableColumns(), this.scan.getSelectionRoot(), this.scan.getPartitionDepth(), this.scan.getSchema(), this.scan.getMaxRecords());
            this.scan.setOperatorId(this.scan.getOperatorId());
        }
        OperatorContext oContext = this.context.newOperatorContext(this.scan);
        try {
            dfs = oContext.newFileSystem(this.plugin.getFsConf());
        }
        catch (IOException e) {
            throw new ExecutionSetupException(String.format("Failed to create FileSystem: %s", e.getMessage()), e);
        }
        LinkedList<RecordReader> readers = new LinkedList<RecordReader>();
        ArrayList<Map<String, String>> implicitColumns = Lists.newArrayList();
        Map<Object, Object> mapWithMaxColumns = Maps.newLinkedHashMap();
        boolean supportsFileImplicitColumns = this.scan.getSelectionRoot() != null;
        for (FileWork fileWork : this.scan.getWorkUnits()) {
            RecordReader recordReader = this.plugin.getRecordReader(this.context, dfs, fileWork, this.scan.getColumns(), this.scan.getUserName());
            readers.add(recordReader);
            List<String> partitionValues = ColumnExplorer.listPartitionValues(fileWork.getPath(), this.scan.getSelectionRoot(), false);
            Map<String, String> implicitValues = columnExplorer.populateColumns(fileWork.getPath(), partitionValues, supportsFileImplicitColumns, dfs);
            implicitColumns.add(implicitValues);
            if (implicitValues.size() <= mapWithMaxColumns.size()) continue;
            mapWithMaxColumns = implicitValues;
        }
        Map diff = Maps.transformValues(mapWithMaxColumns, Functions.constant(null));
        for (Map map : implicitColumns) {
            map.putAll(Maps.difference(map, diff).entriesOnlyOnRight());
        }
        return new ScanBatch(this.context, oContext, readers, implicitColumns);
    }
}

