/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.direct;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.RecordReader;
import org.apache.drill.exec.store.direct.DirectSubScan;

@JsonTypeName(value="direct-scan")
public class DirectGroupScan
extends AbstractGroupScan {
    @JsonProperty
    protected final RecordReader reader;
    @JsonProperty
    protected final ScanStats stats;

    public DirectGroupScan(RecordReader reader) {
        this(reader, ScanStats.TRIVIAL_TABLE);
    }

    @JsonCreator
    public DirectGroupScan(@JsonProperty(value="reader") RecordReader reader, @JsonProperty(value="stats") ScanStats stats) {
        super((String)null);
        this.reader = reader;
        this.stats = stats;
    }

    @Override
    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) {
        assert (endpoints.size() == 1);
    }

    @Override
    public SubScan getSpecificScan(int minorFragmentId) {
        assert (minorFragmentId == 0);
        return new DirectSubScan(this.reader);
    }

    @Override
    public int getMaxParallelizationWidth() {
        return 1;
    }

    @Override
    public ScanStats getScanStats() {
        return this.stats;
    }

    @Override
    @JsonIgnore
    public List<SchemaPath> getColumns() {
        return super.getColumns();
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        assert (children == null || children.isEmpty());
        return new DirectGroupScan(this.reader, this.stats);
    }

    @Override
    public String getDigest() {
        return String.valueOf(this.reader);
    }

    @Override
    public GroupScan clone(List<SchemaPath> columns) {
        return this;
    }
}

