/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.direct;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.store.RecordReader;
import org.apache.drill.exec.store.direct.DirectGroupScan;
import org.apache.hadoop.fs.Path;

@JsonTypeName(value="metadata-direct-scan")
public class MetadataDirectGroupScan
extends DirectGroupScan {
    @JsonProperty
    private final Path selectionRoot;
    @JsonProperty
    private final int numFiles;
    @JsonProperty
    private final boolean usedMetadataSummaryFile;
    @JsonProperty
    private final boolean usedMetastore;

    @JsonCreator
    public MetadataDirectGroupScan(@JsonProperty(value="reader") RecordReader reader, @JsonProperty(value="selectionRoot") Path selectionRoot, @JsonProperty(value="numFiles") int numFiles, @JsonProperty(value="stats") ScanStats stats, @JsonProperty(value="usedMetadataSummaryFile") boolean usedMetadataSummaryFile, @JsonProperty(value="usedMetastore") boolean usedMetastore) {
        super(reader, stats);
        this.selectionRoot = selectionRoot;
        this.numFiles = numFiles;
        this.usedMetadataSummaryFile = usedMetadataSummaryFile;
        this.usedMetastore = usedMetastore;
    }

    @Override
    public Path getSelectionRoot() {
        return this.selectionRoot;
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        assert (children == null || children.isEmpty());
        return new MetadataDirectGroupScan(this.reader, this.selectionRoot, this.numFiles, this.stats, this.usedMetadataSummaryFile, this.usedMetastore);
    }

    @Override
    public GroupScan clone(List<SchemaPath> columns) {
        return this;
    }

    @Override
    public String getDigest() {
        StringBuilder builder = new StringBuilder();
        if (this.selectionRoot != null) {
            builder.append("selectionRoot = ").append(this.selectionRoot).append(", ");
        }
        builder.append("numFiles = ").append(this.numFiles).append(", ");
        builder.append("usedMetadataSummaryFile = ").append(this.usedMetadataSummaryFile).append(", ");
        builder.append("usedMetastore = ").append(this.usedMetastore).append(", ");
        builder.append(super.getDigest());
        return builder.toString();
    }
}

