/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.easy.json.JSONFormatConfig;
import org.apache.drill.exec.store.easy.json.JsonProcessor;
import org.apache.drill.exec.store.easy.json.reader.CountingJsonReader;
import org.apache.drill.exec.vector.complex.fn.JsonReader;
import org.apache.drill.exec.vector.complex.impl.VectorContainerWriter;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class JSONRecordReader
extends AbstractRecordReader {
    private static final Logger logger = LoggerFactory.getLogger(JSONRecordReader.class);
    public static final long DEFAULT_ROWS_PER_BATCH = 4096L;
    private static final OptionValue.OptionScope MIN_SCOPE = OptionValue.OptionScope.SESSION;
    private VectorContainerWriter writer;
    private Path hadoopPath;
    private JsonNode embeddedContent;
    private InputStream stream;
    private final DrillFileSystem fileSystem;
    private JsonProcessor jsonReader;
    private int recordCount;
    private long runningRecordCount;
    private final FragmentContext fragmentContext;
    private final boolean enableAllTextMode;
    private final boolean enableNanInf;
    private final boolean enableEscapeAnyChar;
    private final boolean readNumbersAsDouble;
    private final boolean unionEnabled;
    private long parseErrorCount;
    private final boolean skipMalformedJSONRecords;
    private final boolean printSkippedMalformedJSONRecordLineNumber;
    private final JSONFormatConfig config;
    private JsonProcessor.ReadState write;
    private InputStream inputStream;

    public JSONRecordReader(FragmentContext fragmentContext, Path inputPath, DrillFileSystem fileSystem, List<SchemaPath> columns, JSONFormatConfig config) throws OutOfMemoryException {
        this(fragmentContext, inputPath, null, fileSystem, columns, false, config);
    }

    public JSONRecordReader(FragmentContext fragmentContext, JsonNode embeddedContent, DrillFileSystem fileSystem, List<SchemaPath> columns) throws OutOfMemoryException {
        this(fragmentContext, null, embeddedContent, fileSystem, columns, false, new JSONFormatConfig(null, embeddedContent == null && fragmentContext.getOptions().getOption(ExecConstants.JSON_READER_ALL_TEXT_MODE_VALIDATOR), embeddedContent == null && fragmentContext.getOptions().getOption(ExecConstants.JSON_READ_NUMBERS_AS_DOUBLE_VALIDATOR), fragmentContext.getOptions().getOption(ExecConstants.JSON_SKIP_MALFORMED_RECORDS_VALIDATOR), fragmentContext.getOptions().getOption(ExecConstants.JSON_READER_ESCAPE_ANY_CHAR_VALIDATOR), fragmentContext.getOptions().getOption(ExecConstants.JSON_READER_NAN_INF_NUMBERS_VALIDATOR)));
    }

    public JSONRecordReader(FragmentContext fragmentContext, List<SchemaPath> columns) throws OutOfMemoryException {
        this(fragmentContext, null, null, null, columns, true, new JSONFormatConfig(null, fragmentContext.getOptions().getOption(ExecConstants.JSON_READER_ALL_TEXT_MODE_VALIDATOR), fragmentContext.getOptions().getOption(ExecConstants.JSON_READ_NUMBERS_AS_DOUBLE_VALIDATOR), fragmentContext.getOptions().getOption(ExecConstants.JSON_SKIP_MALFORMED_RECORDS_VALIDATOR), fragmentContext.getOptions().getOption(ExecConstants.JSON_READER_ESCAPE_ANY_CHAR_VALIDATOR), fragmentContext.getOptions().getOption(ExecConstants.JSON_READER_NAN_INF_NUMBERS_VALIDATOR)));
    }

    private JSONRecordReader(FragmentContext fragmentContext, Path inputPath, JsonNode embeddedContent, DrillFileSystem fileSystem, List<SchemaPath> columns, boolean hasInputStream, JSONFormatConfig config) {
        Preconditions.checkArgument(inputPath == null && embeddedContent != null && !hasInputStream || inputPath != null && embeddedContent == null && !hasInputStream || inputPath == null && embeddedContent == null && hasInputStream, "One of inputPath, inputStream or embeddedContent must be set but not all.");
        OptionManager contextOpts = fragmentContext.getOptions();
        if (inputPath != null) {
            this.hadoopPath = inputPath;
        } else {
            this.embeddedContent = embeddedContent;
        }
        this.config = config == null ? new JSONFormatConfig(null, embeddedContent == null && fragmentContext.getOptions().getOption(ExecConstants.JSON_READER_ALL_TEXT_MODE_VALIDATOR), embeddedContent == null && fragmentContext.getOptions().getOption(ExecConstants.JSON_READ_NUMBERS_AS_DOUBLE_VALIDATOR), fragmentContext.getOptions().getOption(ExecConstants.JSON_SKIP_MALFORMED_RECORDS_VALIDATOR), fragmentContext.getOptions().getOption(ExecConstants.JSON_READER_ESCAPE_ANY_CHAR_VALIDATOR), fragmentContext.getOptions().getOption(ExecConstants.JSON_READER_NAN_INF_NUMBERS_VALIDATOR)) : config;
        this.fileSystem = fileSystem;
        this.fragmentContext = fragmentContext;
        this.enableAllTextMode = this.allTextMode(contextOpts);
        this.enableNanInf = this.nanInf(contextOpts);
        this.enableEscapeAnyChar = this.escapeAnyChar(contextOpts);
        this.readNumbersAsDouble = this.readNumbersAsDouble(contextOpts);
        this.unionEnabled = embeddedContent == null && fragmentContext.getOptions().getBoolean("exec.enable_union_type");
        this.skipMalformedJSONRecords = this.skipMalformedJSONRecords(contextOpts);
        this.printSkippedMalformedJSONRecordLineNumber = fragmentContext.getOptions().getOption(ExecConstants.JSON_READER_PRINT_INVALID_RECORDS_LINE_NOS_FLAG_VALIDATOR);
        this.setColumns(columns);
    }

    private boolean allTextMode(OptionManager contextOpts) {
        boolean allTextMode = (Boolean)ObjectUtils.firstNonNull((Object[])new Object[]{contextOpts.getOption("store.json.all_text_mode").getValueMinScope(MIN_SCOPE), this.config.getAllTextMode(), contextOpts.getBoolean("store.json.all_text_mode")});
        return this.embeddedContent == null && allTextMode;
    }

    private boolean readNumbersAsDouble(OptionManager contextOpts) {
        boolean numbersAsDouble = (Boolean)ObjectUtils.firstNonNull((Object[])new Object[]{contextOpts.getOption("store.json.read_numbers_as_double").getValueMinScope(MIN_SCOPE), this.config.getReadNumbersAsDouble(), contextOpts.getBoolean("store.json.read_numbers_as_double")});
        return this.embeddedContent == null && numbersAsDouble;
    }

    private boolean skipMalformedJSONRecords(OptionManager contextOpts) {
        boolean skipMalformedRecords = (Boolean)ObjectUtils.firstNonNull((Object[])new Object[]{contextOpts.getOption("store.json.reader.skip_invalid_records").getValueMinScope(MIN_SCOPE), this.config.getSkipMalformedJSONRecords(), contextOpts.getBoolean("store.json.reader.skip_invalid_records")});
        return this.embeddedContent == null && skipMalformedRecords;
    }

    private boolean escapeAnyChar(OptionManager contextOpts) {
        boolean allowNaN = (Boolean)ObjectUtils.firstNonNull((Object[])new Object[]{contextOpts.getOption("store.json.reader.allow_escape_any_char").getValueMinScope(MIN_SCOPE), this.config.getEscapeAnyChar(), contextOpts.getBoolean("store.json.reader.allow_escape_any_char")});
        return this.embeddedContent == null && allowNaN;
    }

    private boolean nanInf(OptionManager contextOpts) {
        boolean allowNaN = (Boolean)ObjectUtils.firstNonNull((Object[])new Object[]{contextOpts.getOption("store.json.reader.allow_nan_inf").getValueMinScope(MIN_SCOPE), this.config.getNanInf(), contextOpts.getBoolean("store.json.reader.allow_nan_inf")});
        return this.embeddedContent == null && allowNaN;
    }

    @Override
    public String toString() {
        return super.toString() + "[hadoopPath = " + this.hadoopPath + ", currentRecord=" + this.currentRecordNumberInFile() + ", jsonReader=" + this.jsonReader + ", recordCount = " + this.recordCount + ", parseErrorCount = " + this.parseErrorCount + ", runningRecordCount = " + this.runningRecordCount + ", ...]";
    }

    @Override
    public void setup(OperatorContext context, OutputMutator output) throws ExecutionSetupException {
        try {
            if (this.hadoopPath != null) {
                this.stream = this.fileSystem.openPossiblyCompressedStream(this.hadoopPath);
            }
            this.writer = new VectorContainerWriter(output, this.unionEnabled);
            this.jsonReader = this.isSkipQuery() ? new CountingJsonReader(this.fragmentContext.getManagedBuffer(), this.enableNanInf, this.enableEscapeAnyChar) : new JsonReader.Builder(this.fragmentContext.getManagedBuffer()).schemaPathColumns(ImmutableList.copyOf(this.getColumns())).allTextMode(this.enableAllTextMode).skipOuterList(true).readNumbersAsDouble(this.readNumbersAsDouble).enableNanInf(this.enableNanInf).enableEscapeAnyChar(this.enableEscapeAnyChar).build();
            this.setupParser();
        }
        catch (Exception e) {
            this.handleAndRaise("Failure reading JSON file", e);
        }
    }

    @Override
    protected List<SchemaPath> getDefaultColumnsToRead() {
        return ImmutableList.of();
    }

    private void setupParser() throws IOException {
        if (this.hadoopPath != null) {
            this.jsonReader.setSource(this.stream);
        } else if (this.inputStream != null) {
            this.jsonReader.setSource(this.inputStream);
        } else {
            this.jsonReader.setSource(this.embeddedContent);
        }
        this.jsonReader.setIgnoreJSONParseErrors(this.skipMalformedJSONRecords);
    }

    protected void handleAndRaise(String suffix, Exception e) throws UserException {
        String message = e.getMessage();
        int columnNr = -1;
        if (e instanceof JsonParseException) {
            JsonParseException ex = (JsonParseException)e;
            message = ex.getOriginalMessage();
            columnNr = ex.getLocation().getColumnNr();
        }
        UserException.Builder exceptionBuilder = UserException.dataReadError(e).message("%s - %s", suffix, message);
        if (columnNr > 0) {
            exceptionBuilder.pushContext("Column ", columnNr);
        }
        if (this.hadoopPath != null) {
            exceptionBuilder.pushContext("Record ", this.currentRecordNumberInFile()).pushContext("File ", this.hadoopPath.toUri().getPath());
        }
        throw exceptionBuilder.build(logger);
    }

    private long currentRecordNumberInFile() {
        return this.runningRecordCount + (long)this.recordCount + 1L;
    }

    @Override
    public int next() {
        this.writer.allocate();
        this.writer.reset();
        this.recordCount = 0;
        this.parseErrorCount = 0L;
        if (this.write == JsonProcessor.ReadState.JSON_RECORD_PARSE_EOF_ERROR) {
            return this.recordCount;
        }
        while ((long)this.recordCount < 4096L) {
            try {
                this.writer.setPosition(this.recordCount);
                this.write = this.jsonReader.write(this.writer);
                if (this.write == JsonProcessor.ReadState.WRITE_SUCCEED) {
                    ++this.recordCount;
                    continue;
                }
                if (this.write != JsonProcessor.ReadState.JSON_RECORD_PARSE_ERROR && this.write != JsonProcessor.ReadState.JSON_RECORD_PARSE_EOF_ERROR) break;
                if (!this.skipMalformedJSONRecords) {
                    this.handleAndRaise("Error parsing JSON", new Exception());
                }
                ++this.parseErrorCount;
                if (this.printSkippedMalformedJSONRecordLineNumber) {
                    logger.debug("Error parsing JSON in {}: line: {}", (Object)this.hadoopPath.getName(), (Object)((long)this.recordCount + this.parseErrorCount));
                }
                if (this.write != JsonProcessor.ReadState.JSON_RECORD_PARSE_EOF_ERROR) continue;
                break;
            }
            catch (IOException ex) {
                this.handleAndRaise("Error parsing JSON", ex);
            }
        }
        if (this.recordCount > 0) {
            this.jsonReader.ensureAtLeastOneField(this.writer);
        }
        this.writer.setValueCount(this.recordCount);
        this.updateRunningCount();
        return this.recordCount;
    }

    private void updateRunningCount() {
        this.runningRecordCount += (long)this.recordCount;
    }

    public void setInputStream(InputStream in) {
        this.inputStream = in;
    }

    @Override
    public void close() throws Exception {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
    }
}

