/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json;

import java.io.IOException;
import java.io.InputStream;
import org.apache.drill.common.exceptions.ChildErrorContext;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.physical.impl.scan.file.FileScanFramework;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedReader;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.easy.json.loader.JsonLoader;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.hadoop.mapred.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonBatchReader
implements ManagedReader<FileScanFramework.FileSchemaNegotiator> {
    private static final Logger logger = LoggerFactory.getLogger(JsonBatchReader.class);
    private JsonLoader jsonLoader;

    @Override
    public boolean open(FileScanFramework.FileSchemaNegotiator negotiator) {
        InputStream stream;
        DrillFileSystem fileSystem = negotiator.fileSystem();
        final FileSplit split = negotiator.split();
        try {
            stream = fileSystem.openPossiblyCompressedStream(split.getPath());
        }
        catch (IOException e) {
            throw UserException.dataReadError(e).addContext("Failure to open JSON file", split.getPath().toString()).build(logger);
        }
        ChildErrorContext errorContext = new ChildErrorContext(negotiator.parentErrorContext()){

            @Override
            public void addContext(UserException.Builder builder) {
                super.addContext(builder);
                builder.addContext("File name", split.getPath().toString());
            }
        };
        negotiator.setErrorContext(errorContext);
        this.jsonLoader = new JsonLoaderImpl.JsonLoaderBuilder().resultSetLoader(negotiator.build()).standardOptions(negotiator.queryOptions()).providedSchema(negotiator.providedSchema()).errorContext(errorContext).fromStream(stream).build();
        return true;
    }

    @Override
    public boolean next() {
        return this.jsonLoader.readBatch();
    }

    @Override
    public void close() {
        if (this.jsonLoader != null) {
            this.jsonLoader.close();
            this.jsonLoader = null;
        }
    }
}

