/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json;

import java.io.InputStream;
import org.apache.drill.common.exceptions.ChildErrorContext;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.framework.SchemaNegotiator;
import org.apache.drill.exec.store.easy.json.loader.JsonLoader;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;

public class JsonStreamBatchReader
implements ManagedReader<SchemaNegotiator> {
    private JsonLoader jsonLoader;
    private final InputStream source;

    public JsonStreamBatchReader(InputStream source) {
        this.source = source;
    }

    @Override
    public boolean open(SchemaNegotiator negotiator) {
        ChildErrorContext errorContext = new ChildErrorContext(negotiator.parentErrorContext());
        negotiator.setErrorContext(errorContext);
        this.jsonLoader = new JsonLoaderImpl.JsonLoaderBuilder().resultSetLoader(negotiator.build()).standardOptions(negotiator.queryOptions()).providedSchema(negotiator.providedSchema()).errorContext(errorContext).fromStream(this.source).build();
        return true;
    }

    @Override
    public boolean next() {
        return this.jsonLoader.readBatch();
    }

    @Override
    public void close() {
        if (this.jsonLoader != null) {
            this.jsonLoader.close();
            this.jsonLoader = null;
        }
    }
}

