/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.extended;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.parser.JsonStructureParser;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.parser.ValueParser;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;

public abstract class BaseExtendedValueParser
extends ValueParser {
    protected static final String SCALAR_HINT = "{\"%s\": scalar}";

    public BaseExtendedValueParser(JsonStructureParser structParser, ScalarListener listener) {
        super(structParser, listener);
    }

    protected abstract String typeName();

    protected void parseExtended(TokenIterator tokenizer, String typeName) {
        JsonToken token = tokenizer.requireNext();
        if (token == JsonToken.VALUE_NULL) {
            this.listener.onValue(token, tokenizer);
            return;
        }
        if (token.isScalarValue()) {
            this.listener.onValue(token, tokenizer);
            return;
        }
        this.requireToken(token, JsonToken.START_OBJECT);
        this.requireField(tokenizer, typeName);
        this.listener.onValue(this.requireScalar(tokenizer), tokenizer);
        this.requireToken(tokenizer, JsonToken.END_OBJECT);
    }

    protected void requireToken(TokenIterator tokenizer, JsonToken expected) {
        this.requireToken(tokenizer.requireNext(), expected);
    }

    protected void requireToken(JsonToken token, JsonToken expected) {
        if (token != expected) {
            throw this.syntaxError();
        }
    }

    protected JsonToken requireScalar(TokenIterator tokenizer) {
        JsonToken token = tokenizer.requireNext();
        if (!token.isScalarValue()) {
            throw this.syntaxError();
        }
        return token;
    }

    protected void requireField(TokenIterator tokenizer, String fieldName) {
        this.requireToken(tokenizer, JsonToken.FIELD_NAME);
        if (!tokenizer.textValue().equals(fieldName)) {
            throw this.syntaxError();
        }
    }

    protected RuntimeException syntaxError() {
        return this.errorFactory().structureError(String.format("Expected <%s> for extended type %s.", this.formatHint(), this.typeName()));
    }

    protected abstract String formatHint();
}

