/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.extended;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.extended.BaseExtendedValueParser;
import org.apache.drill.exec.store.easy.json.parser.JsonStructureParser;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;

public class MongoBinaryValueParser
extends BaseExtendedValueParser {
    protected static final String BINARY_HINT = "{\"$binary\": {base64: (\"<payload>\", subType: \"<t>\" }) | (\"<payload>\", \"$type\": \"<t>\") }";

    public MongoBinaryValueParser(JsonStructureParser structParser, ScalarListener listener) {
        super(structParser, listener);
    }

    @Override
    protected String typeName() {
        return "$binary";
    }

    @Override
    public void parse(TokenIterator tokenizer) {
        JsonToken token = tokenizer.requireNext();
        if (token == JsonToken.VALUE_NULL) {
            this.listener.onValue(token, tokenizer);
            return;
        }
        if (token.isScalarValue()) {
            this.listener.onValue(token, tokenizer);
            return;
        }
        this.requireToken(token, JsonToken.START_OBJECT);
        this.requireToken(tokenizer, JsonToken.FIELD_NAME);
        String fieldName = tokenizer.textValue();
        if (fieldName.equals("$type")) {
            this.parseV1Format(fieldName, tokenizer);
        } else {
            if (!fieldName.equals("$binary")) {
                throw this.syntaxError();
            }
            if (tokenizer.peek() == JsonToken.START_OBJECT) {
                this.parseV2Format(tokenizer);
            } else {
                this.parseV1Format(fieldName, tokenizer);
            }
        }
    }

    private void parseV1Format(String fieldName, TokenIterator tokenizer) {
        boolean sawData;
        block12: {
            sawData = false;
            block7: while (true) {
                JsonToken token = this.requireScalar(tokenizer);
                if (fieldName.equals("$binary")) {
                    if (sawData) {
                        throw this.syntaxError();
                    }
                    sawData = true;
                    this.listener.onValue(token, tokenizer);
                }
                if ((token = tokenizer.requireNext()) == JsonToken.END_OBJECT) break block12;
                if (token != JsonToken.FIELD_NAME) {
                    throw this.syntaxError();
                }
                switch (fieldName = tokenizer.textValue()) {
                    case "$binary": 
                    case "$type": {
                        continue block7;
                    }
                }
                break;
            }
            throw this.syntaxError();
        }
        if (!sawData) {
            throw this.syntaxError();
        }
    }

    private void parseV2Format(TokenIterator tokenizer) {
        JsonToken token;
        boolean sawData = false;
        this.requireToken(tokenizer, JsonToken.START_OBJECT);
        block8: while ((token = tokenizer.requireNext()) != JsonToken.END_OBJECT) {
            if (token != JsonToken.FIELD_NAME) {
                throw this.syntaxError();
            }
            switch (tokenizer.textValue()) {
                case "base64": {
                    if (sawData) {
                        throw this.syntaxError();
                    }
                    sawData = true;
                    this.listener.onValue(this.requireScalar(tokenizer), tokenizer);
                    continue block8;
                }
                case "subType": {
                    this.requireScalar(tokenizer);
                    continue block8;
                }
            }
            throw this.syntaxError();
        }
        this.requireToken(tokenizer, JsonToken.END_OBJECT);
    }

    @Override
    protected String formatHint() {
        return BINARY_HINT;
    }
}

