/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.extended;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.extended.BaseExtendedValueParser;
import org.apache.drill.exec.store.easy.json.parser.JsonStructureParser;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;

public class MongoDateValueParser
extends BaseExtendedValueParser {
    private static final String DATE_HINT = "^{\"$date\": scalar | " + String.format("{\"%s\": scalar}", "$numberDouble") + "}";

    public MongoDateValueParser(JsonStructureParser structParser, ScalarListener listener) {
        super(structParser, listener);
    }

    @Override
    protected String typeName() {
        return "$date";
    }

    @Override
    public void parse(TokenIterator tokenizer) {
        JsonToken token = tokenizer.requireNext();
        if (token == JsonToken.VALUE_NULL) {
            this.listener.onValue(token, tokenizer);
            return;
        }
        if (token.isScalarValue()) {
            this.listener.onValue(token, tokenizer);
            return;
        }
        this.requireToken(token, JsonToken.START_OBJECT);
        this.requireField(tokenizer, "$date");
        token = tokenizer.requireNext();
        if (token == JsonToken.START_OBJECT) {
            tokenizer.unget(token);
            this.parseExtended(tokenizer, "$numberLong");
        } else {
            tokenizer.unget(token);
            this.listener.onValue(this.requireScalar(tokenizer), tokenizer);
        }
        this.requireToken(tokenizer, JsonToken.END_OBJECT);
    }

    @Override
    protected String formatHint() {
        return DATE_HINT;
    }
}

