/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.loader;

import java.util.function.Function;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.easy.json.loader.FieldDefn;
import org.apache.drill.exec.store.easy.json.loader.FieldFactory;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.loader.SimpleArrayListener;
import org.apache.drill.exec.store.easy.json.loader.TupleParser;
import org.apache.drill.exec.store.easy.json.loader.VariantParser;
import org.apache.drill.exec.store.easy.json.parser.ElementParser;
import org.apache.drill.exec.store.easy.json.parser.FieldParserFactory;
import org.apache.drill.exec.store.easy.json.parser.ValueParser;
import org.apache.drill.exec.store.easy.json.values.BigIntListener;
import org.apache.drill.exec.store.easy.json.values.BinaryValueListener;
import org.apache.drill.exec.store.easy.json.values.BooleanListener;
import org.apache.drill.exec.store.easy.json.values.DateValueListener;
import org.apache.drill.exec.store.easy.json.values.DecimalValueListener;
import org.apache.drill.exec.store.easy.json.values.DoubleListener;
import org.apache.drill.exec.store.easy.json.values.IntervalValueListener;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;
import org.apache.drill.exec.store.easy.json.values.StrictIntValueListener;
import org.apache.drill.exec.store.easy.json.values.TimeValueListener;
import org.apache.drill.exec.store.easy.json.values.TimestampValueListener;
import org.apache.drill.exec.store.easy.json.values.VarCharListener;
import org.apache.drill.exec.vector.accessor.ArrayWriter;
import org.apache.drill.exec.vector.accessor.ObjectWriter;
import org.apache.drill.exec.vector.accessor.ScalarWriter;
import org.apache.drill.exec.vector.accessor.TupleWriter;
import org.apache.drill.exec.vector.accessor.VariantWriter;

public abstract class BaseFieldFactory
implements FieldFactory {
    protected final JsonLoaderImpl loader;
    protected final FieldFactory child;

    public BaseFieldFactory(JsonLoaderImpl loader) {
        this(loader, null);
    }

    public BaseFieldFactory(JsonLoaderImpl loader, FieldFactory child) {
        this.loader = loader;
        this.child = child;
    }

    protected FieldParserFactory parserFactory() {
        return this.loader().parser().fieldFactory();
    }

    @Override
    public ElementParser ignoredFieldParser() {
        return this.parserFactory().ignoredFieldParser();
    }

    protected JsonLoaderImpl loader() {
        return this.loader;
    }

    @Override
    public ValueParser scalarParserFor(FieldDefn fieldDefn, ColumnMetadata colSchema) {
        return this.scalarParserFor(fieldDefn.scalarWriterFor(colSchema));
    }

    public ValueParser scalarParserFor(ScalarWriter writer) {
        return this.parserFactory().simpleValueParser(this.scalarListenerFor(writer));
    }

    protected ElementParser scalarArrayParserFor(ValueParser element) {
        return this.parserFactory().scalarArrayValueParser(new SimpleArrayListener(), element);
    }

    protected ElementParser scalarArrayParserFor(ArrayWriter writer) {
        return this.scalarArrayParserFor(this.scalarParserFor(writer.scalar()));
    }

    protected ElementParser multiDimScalarArrayFor(ObjectWriter writer, int dims) {
        return this.buildOuterArrays(writer, dims, innerWriter -> this.scalarArrayParserFor(innerWriter.array()));
    }

    public ElementParser objectParserFor(FieldDefn fieldDefn) {
        return this.objectParserFor(fieldDefn, MetadataUtils.newMap(fieldDefn.key()), null);
    }

    protected ElementParser objectParserFor(FieldDefn fieldDefn, ColumnMetadata colSchema, TupleMetadata providedSchema) {
        return this.objectParserFor(fieldDefn.fieldWriterFor(colSchema).tuple(), providedSchema);
    }

    protected ElementParser objectArrayParserFor(FieldDefn fieldDefn, ColumnMetadata colSchema, TupleMetadata providedSchema) {
        return this.objectArrayParserFor(fieldDefn.fieldWriterFor(colSchema).array(), providedSchema);
    }

    protected ElementParser objectArrayParserFor(ArrayWriter arrayWriter, TupleMetadata providedSchema) {
        return this.parserFactory().arrayValueParser(new SimpleArrayListener.StructureArrayListener(arrayWriter), this.objectParserFor(arrayWriter.tuple(), providedSchema));
    }

    protected ElementParser objectParserFor(TupleWriter writer, TupleMetadata providedSchema) {
        return this.parserFactory().objectValueParser(new TupleParser(this.loader, writer, providedSchema));
    }

    public ElementParser multiDimObjectArrayFor(ObjectWriter writer, int dims, TupleMetadata providedSchema) {
        return this.buildOuterArrays(writer, dims, innerWriter -> this.objectArrayParserFor(innerWriter.array(), providedSchema));
    }

    protected ElementParser variantParserFor(VariantWriter writer) {
        return new VariantParser(this.loader, writer);
    }

    protected ElementParser variantArrayParserFor(ArrayWriter arrayWriter) {
        return this.parserFactory().arrayValueParser(new SimpleArrayListener.ListArrayListener(arrayWriter), this.variantParserFor(arrayWriter.variant()));
    }

    protected ElementParser multiDimVariantArrayParserFor(ObjectWriter writer, int dims) {
        return this.buildOuterArrays(writer, dims, innerWriter -> this.variantArrayParserFor(innerWriter.array()));
    }

    public ElementParser buildOuterArrays(ObjectWriter writer, int dims, Function<ObjectWriter, ElementParser> innerCreator) {
        ObjectWriter[] writers = new ObjectWriter[dims];
        writers[0] = writer;
        for (int i = 1; i < dims; ++i) {
            writers[i] = writers[i - 1].array().entry();
        }
        ElementParser prevElementParser = innerCreator.apply(writers[dims - 1]);
        for (int i = dims - 2; i >= 0; --i) {
            prevElementParser = this.parserFactory().arrayValueParser(new SimpleArrayListener.StructureArrayListener(writers[i].array()), prevElementParser);
        }
        return prevElementParser;
    }

    protected ColumnMetadata repeatedListSchemaFor(String key, int dims, ColumnMetadata innerArray) {
        ColumnMetadata prev = innerArray;
        for (int i = 1; i < dims; ++i) {
            prev = MetadataUtils.newRepeatedList(key, prev);
        }
        return prev;
    }

    public ScalarListener scalarListenerFor(ScalarWriter writer) {
        switch (writer.schema().type()) {
            case BIGINT: {
                return new BigIntListener(this.loader, writer);
            }
            case BIT: {
                return new BooleanListener(this.loader, writer);
            }
            case FLOAT4: 
            case FLOAT8: {
                return new DoubleListener(this.loader, writer);
            }
            case VARCHAR: {
                return new VarCharListener(this.loader, writer);
            }
            case INT: 
            case SMALLINT: {
                return new StrictIntValueListener(this.loader, writer);
            }
            case INTERVAL: 
            case INTERVALDAY: 
            case INTERVALYEAR: {
                return new IntervalValueListener(this.loader, writer);
            }
            case DATE: {
                return new DateValueListener(this.loader, writer);
            }
            case TIME: {
                return new TimeValueListener(this.loader, writer);
            }
            case TIMESTAMP: {
                return new TimestampValueListener(this.loader, writer);
            }
            case VARBINARY: {
                return new BinaryValueListener(this.loader, writer);
            }
            case VARDECIMAL: {
                return new DecimalValueListener(this.loader, writer);
            }
        }
        throw this.loader.buildError(UserException.internalError(null).message("Unsupported JSON reader type: %s", writer.schema().type().name()));
    }

    @Override
    public ElementParser forceNullResolution(FieldDefn fieldDefn) {
        return this.child.forceArrayResolution(fieldDefn);
    }

    @Override
    public ElementParser forceArrayResolution(FieldDefn fieldDefn) {
        return this.child.forceArrayResolution(fieldDefn);
    }
}

