/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.loader;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.easy.json.loader.TupleParser;
import org.apache.drill.exec.store.easy.json.parser.JsonStructureParser;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.parser.ValueDef;
import org.apache.drill.exec.store.easy.json.parser.ValueDefFactory;
import org.apache.drill.exec.vector.accessor.ObjectWriter;
import org.apache.drill.exec.vector.accessor.ScalarWriter;
import org.apache.drill.exec.vector.accessor.TupleWriter;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class FieldDefn {
    private final TupleParser tupleParser;
    private final String key;
    private final TokenIterator tokenizer;
    private ValueDef valueDef;
    private ColumnMetadata providedColumn;

    public FieldDefn(TupleParser tupleParser, String key, TokenIterator tokenizer) {
        this(tupleParser, key, tokenizer, false);
    }

    public FieldDefn(TupleParser tupleParser, String key, TokenIterator tokenizer, boolean isArray) {
        this.tupleParser = tupleParser;
        this.key = key;
        this.tokenizer = tokenizer;
        if (isArray) {
            this.valueDef = ValueDefFactory.lookAhead(tokenizer);
            this.valueDef = new ValueDef(this.valueDef.type(), this.valueDef.dimensions() + 1);
        }
    }

    public String key() {
        return this.key;
    }

    public TupleParser tupleParser() {
        return this.tupleParser;
    }

    public TokenIterator tokenizer() {
        return this.tokenizer;
    }

    public JsonStructureParser parser() {
        return this.tupleParser.structParser();
    }

    public ValueDef lookahead() {
        Preconditions.checkState(this.tokenizer != null);
        if (this.valueDef == null) {
            this.valueDef = ValueDefFactory.lookAhead(this.tokenizer);
        }
        return this.valueDef;
    }

    public TupleWriter writer() {
        return this.tupleParser.writer();
    }

    public ColumnMetadata providedColumn() {
        if (this.providedColumn == null) {
            TupleMetadata tupleSchema = this.tupleParser.providedSchema();
            this.providedColumn = tupleSchema == null ? null : tupleSchema.metadata(this.key);
        }
        return this.providedColumn;
    }

    public ColumnMetadata schemaFor(TypeProtos.MinorType type, boolean isArray) {
        return this.schemaFor(type, isArray, false);
    }

    public ColumnMetadata schemaFor(TypeProtos.MinorType type, boolean isArray, boolean forUnknownSchema) {
        return MetadataUtils.newScalar(this.key, type, this.mode(isArray), forUnknownSchema);
    }

    public TypeProtos.DataMode mode(boolean isArray) {
        return isArray ? TypeProtos.DataMode.REPEATED : TypeProtos.DataMode.OPTIONAL;
    }

    public ScalarWriter scalarWriterFor(TypeProtos.MinorType type, boolean isArray) {
        return this.scalarWriterFor(this.schemaFor(type, isArray));
    }

    public ScalarWriter scalarWriterFor(ColumnMetadata colSchema) {
        ObjectWriter writer = this.fieldWriterFor(colSchema);
        return colSchema.isArray() ? writer.array().scalar() : writer.scalar();
    }

    public ObjectWriter fieldWriterFor(ColumnMetadata colSchema) {
        int index = this.writer().addColumn(colSchema);
        return this.writer().column(index);
    }
}

