/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.loader;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonToken;
import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.exceptions.EmptyErrorContext;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.exec.store.ImplicitColumnUtils;
import org.apache.drill.exec.store.easy.json.extended.ExtendedTypeFieldFactory;
import org.apache.drill.exec.store.easy.json.loader.BaseFieldFactory;
import org.apache.drill.exec.store.easy.json.loader.FieldFactory;
import org.apache.drill.exec.store.easy.json.loader.InferredFieldFactory;
import org.apache.drill.exec.store.easy.json.loader.JsonLoader;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderOptions;
import org.apache.drill.exec.store.easy.json.loader.ProvidedFieldFactory;
import org.apache.drill.exec.store.easy.json.loader.TupleParser;
import org.apache.drill.exec.store.easy.json.parser.ErrorFactory;
import org.apache.drill.exec.store.easy.json.parser.JsonStructureParser;
import org.apache.drill.exec.store.easy.json.parser.MessageParser;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.parser.ValueDef;
import org.apache.drill.exec.vector.accessor.UnsupportedConversionError;
import org.apache.drill.exec.vector.complex.fn.DrillBufInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLoaderImpl
implements JsonLoader,
ErrorFactory {
    private static final Logger logger = LoggerFactory.getLogger(JsonLoaderImpl.class);
    private final ResultSetLoader rsLoader;
    private final JsonLoaderOptions options;
    private final CustomErrorContext errorContext;
    private final JsonStructureParser parser;
    private final FieldFactory fieldFactory;
    private final ImplicitColumnUtils.ImplicitColumns implicitFields;
    private final Map<String, Object> listenerColumnMap;
    private final Iterable<InputStream> streams;
    private final int maxRows;
    private boolean eof;
    private final List<NullTypeMarker> nullStates = new ArrayList<NullTypeMarker>();

    protected JsonLoaderImpl(JsonLoaderBuilder builder) {
        this.rsLoader = builder.rsLoader;
        this.options = builder.options;
        this.errorContext = builder.errorContext;
        this.implicitFields = builder.implicitFields;
        this.maxRows = builder.maxRows;
        this.fieldFactory = this.buildFieldFactory(builder);
        this.listenerColumnMap = builder.listenerColumnMap;
        this.streams = builder.streams;
        this.parser = this.buildParser(builder);
    }

    private JsonStructureParser buildParser(JsonLoaderBuilder builder) {
        return new JsonStructureParser.JsonStructureParserBuilder().fromStream(builder.streams).fromReader(builder.reader).options(builder.options).parserFactory(parser -> new TupleParser((JsonStructureParser)parser, this, this.rsLoader.writer(), builder.providedSchema)).errorFactory(this).listenerColumnMap(this.listenerColumnMap).messageParser(builder.messageParser).dataPath(builder.dataPath).build();
    }

    private FieldFactory buildFieldFactory(JsonLoaderBuilder builder) {
        BaseFieldFactory factory = new InferredFieldFactory(this);
        if (this.options.enableExtendedTypes) {
            factory = new ExtendedTypeFieldFactory(this, factory);
        }
        if (builder.providedSchema != null) {
            factory = new ProvidedFieldFactory(this, factory);
        }
        return factory;
    }

    public JsonLoaderOptions options() {
        return this.options;
    }

    public JsonStructureParser parser() {
        return this.parser;
    }

    public FieldFactory fieldFactory() {
        return this.fieldFactory;
    }

    public Map<String, Object> listenerColumnMap() {
        return this.listenerColumnMap;
    }

    @Override
    public boolean readBatch() {
        if (this.eof) {
            return false;
        }
        RowSetLoader rowWriter = this.rsLoader.writer();
        while (rowWriter.start()) {
            if (this.parser.next()) {
                if (this.implicitFields != null) {
                    this.implicitFields.writeImplicitColumns();
                }
                rowWriter.save();
                continue;
            }
            if (rowWriter.limitReached(this.maxRows)) {
                this.eof = true;
                break;
            }
            if (this.implicitFields != null) {
                this.implicitFields.writeImplicitColumns();
                rowWriter.save();
            }
            this.eof = true;
            break;
        }
        this.endBatch();
        return this.rsLoader.hasRows();
    }

    public void addNullMarker(NullTypeMarker marker) {
        this.nullStates.add(marker);
    }

    public void removeNullMarker(NullTypeMarker marker) {
        this.nullStates.remove(marker);
    }

    protected void endBatch() {
        ArrayList<NullTypeMarker> copy = new ArrayList<NullTypeMarker>(this.nullStates);
        copy.forEach(NullTypeMarker::forceResolution);
        assert (this.nullStates.isEmpty());
    }

    @Override
    public void close() {
        this.parser.close();
        for (InputStream stream : this.streams) {
            try {
                AutoCloseables.close(stream);
            }
            catch (Exception ex) {
                logger.warn("Failed to close an input stream, a system resource leak may ensue.", (Throwable)ex);
            }
        }
    }

    @Override
    public RuntimeException parseError(String msg, JsonParseException e) {
        throw this.buildError(UserException.dataReadError((Throwable)e).addContext(msg));
    }

    @Override
    public RuntimeException ioException(IOException e) {
        throw this.buildError(UserException.dataReadError(e));
    }

    @Override
    public RuntimeException structureError(String msg) {
        if (this.options.skipMalformedRecords) {
            throw new TokenIterator.RecoverableJsonException();
        }
        throw this.buildError(UserException.dataReadError().message(msg, new Object[0]));
    }

    @Override
    public RuntimeException syntaxError(JsonParseException e) {
        throw this.buildError(UserException.dataReadError((Throwable)e).message("Error parsing JSON - %s", e.getMessage()).addContext("Syntax error"));
    }

    @Override
    public RuntimeException typeError(UnsupportedConversionError e) {
        throw this.buildError(UserException.validationError(e).addContext("Unsupported type conversion"));
    }

    @Override
    public RuntimeException syntaxError(JsonToken token) {
        if (this.options.skipMalformedRecords) {
            throw new TokenIterator.RecoverableJsonException();
        }
        throw this.buildError(UserException.dataReadError().message("Syntax error on token: " + token.toString(), new Object[0]));
    }

    @Override
    public RuntimeException unrecoverableError() {
        throw this.buildError(UserException.dataReadError().addContext("Unrecoverable syntax error on token").addContext("Recovery attempts", this.parser.recoverableErrorCount()));
    }

    public UserException typeConversionError(ColumnMetadata schema, ValueDef valueDef) {
        StringBuilder buf = new StringBuilder().append(valueDef.type().name().toLowerCase());
        if (valueDef.isArray()) {
            for (int i = 0; i < valueDef.dimensions(); ++i) {
                buf.append("[]");
            }
        }
        return this.typeConversionError(schema, buf.toString());
    }

    public UserException typeConversionError(ColumnMetadata schema, String tokenType) {
        return this.buildError(schema, UserException.dataReadError().message("Type of JSON token is not compatible with its column", new Object[0]).addContext("JSON token type", tokenType));
    }

    public UserException dataConversionError(ColumnMetadata schema, String tokenType, String value) {
        return this.buildError(schema, UserException.dataReadError().message("Type of JSON token is not compatible with its column", new Object[0]).addContext("JSON token type", tokenType).addContext("JSON token", value));
    }

    public UserException nullDisallowedError(ColumnMetadata schema) {
        return this.buildError(schema, UserException.dataReadError().message("JSON value \"null\" for a column that does not allow null values", new Object[0]));
    }

    public UserException unsupportedType(ColumnMetadata schema) {
        return this.buildError(schema, UserException.validationError().message("JSON reader does not support the provided column type", new Object[0]));
    }

    public UserException unsupportedJsonTypeException(String key, ValueDef.JsonType jsonType) {
        return this.buildError(UserException.dataReadError().message("JSON reader does not support the JSON data type", new Object[0]).addContext("Field", key).addContext("JSON type", jsonType.toString()));
    }

    @Override
    public RuntimeException messageParseError(MessageParser.MessageContextException e) {
        return this.buildError(UserException.validationError(e).message("Syntax error when parsing a JSON message", new Object[0]).addContext(e.getMessage()).addContext("Looking for field", e.nextElement).addContext("On token", e.token.name()));
    }

    public UserException buildError(ColumnMetadata schema, UserException.Builder builder) {
        return this.buildError(builder.addContext("Column", schema.name()).addContext("Column type", schema.typeString()));
    }

    protected UserException buildError(UserException.Builder builder) {
        builder.addContext(this.errorContext);
        if (this.parser != null) {
            builder.addContext("Line", this.parser.lineNumber()).addContext("Position", this.parser.columnNumber());
            String token = this.parser.token();
            if (token != null) {
                builder.addContext("Near token", token);
            }
        }
        return builder.build(logger);
    }

    public static class JsonLoaderBuilder {
        private ResultSetLoader rsLoader;
        private TupleMetadata providedSchema;
        private JsonLoaderOptions options;
        private CustomErrorContext errorContext;
        private Iterable<InputStream> streams;
        private Reader reader;
        private String dataPath;
        private MessageParser messageParser;
        private ImplicitColumnUtils.ImplicitColumns implicitFields;
        private int maxRows;
        private Map<String, Object> listenerColumnMap;

        public JsonLoaderBuilder resultSetLoader(ResultSetLoader rsLoader) {
            this.rsLoader = rsLoader;
            return this;
        }

        public JsonLoaderBuilder providedSchema(TupleMetadata providedSchema) {
            this.providedSchema = providedSchema;
            return this;
        }

        public JsonLoaderBuilder listenerColumnMap(Map<String, Object> listenerColumnMap) {
            this.listenerColumnMap = listenerColumnMap;
            return this;
        }

        public JsonLoaderBuilder standardOptions(OptionSet optionSet) {
            this.options = new JsonLoaderOptions(optionSet);
            return this;
        }

        public JsonLoaderBuilder options(JsonLoaderOptions options) {
            this.options = options;
            return this;
        }

        public JsonLoaderBuilder implicitFields(ImplicitColumnUtils.ImplicitColumns metadata) {
            this.implicitFields = metadata;
            return this;
        }

        public JsonLoaderBuilder errorContext(CustomErrorContext errorContext) {
            this.errorContext = errorContext;
            return this;
        }

        public JsonLoaderBuilder fromStream(InputStream ... stream) {
            this.streams = Arrays.asList(stream);
            return this;
        }

        public JsonLoaderBuilder fromStream(Iterable<InputStream> streams) {
            this.streams = streams;
            return this;
        }

        public JsonLoaderBuilder fromStream(int start, int end, DrillBuf buf) {
            this.streams = Collections.singletonList(DrillBufInputStream.getStream(start, end, buf));
            return this;
        }

        public JsonLoaderBuilder fromString(String jsonString) {
            this.streams = Collections.singletonList(IOUtils.toInputStream((String)jsonString, (Charset)Charset.defaultCharset()));
            return this;
        }

        public JsonLoaderBuilder fromReader(Reader reader) {
            this.reader = reader;
            return this;
        }

        public JsonLoaderBuilder messageParser(MessageParser messageParser) {
            this.messageParser = messageParser;
            return this;
        }

        public JsonLoaderBuilder dataPath(String dataPath) {
            this.dataPath = dataPath;
            return this;
        }

        public JsonLoaderBuilder maxRows(int maxRows) {
            this.maxRows = maxRows;
            return this;
        }

        public JsonLoader build() {
            if (this.options == null) {
                this.options = new JsonLoaderOptions();
            }
            if (this.errorContext == null) {
                this.errorContext = EmptyErrorContext.INSTANCE;
            }
            return new JsonLoaderImpl(this);
        }
    }

    static interface NullTypeMarker {
        public void forceResolution();
    }
}

