/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.loader;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.easy.json.loader.BaseFieldFactory;
import org.apache.drill.exec.store.easy.json.loader.FieldDefn;
import org.apache.drill.exec.store.easy.json.loader.FieldFactory;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.ElementParser;
import org.apache.drill.exec.store.easy.json.parser.FieldParserFactory;
import org.apache.drill.exec.store.easy.json.parser.ValueParser;
import org.apache.drill.exec.store.easy.json.values.VarCharListener;
import org.apache.drill.exec.vector.accessor.ObjectWriter;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class ProvidedFieldFactory
extends BaseFieldFactory {
    public ProvidedFieldFactory(JsonLoaderImpl loader, FieldFactory child) {
        super(loader, child);
    }

    @Override
    public ElementParser fieldParser(FieldDefn fieldDefn) {
        if (fieldDefn.providedColumn() == null) {
            return this.child.fieldParser(fieldDefn);
        }
        return this.parserFor(fieldDefn);
    }

    public ElementParser parserFor(FieldDefn fieldDefn) {
        ColumnMetadata providedCol = fieldDefn.providedColumn();
        switch (providedCol.structureType()) {
            case PRIMITIVE: {
                return this.primitiveParserFor(fieldDefn);
            }
            case TUPLE: {
                return this.objectParserForSchema(fieldDefn);
            }
            case VARIANT: {
                return this.variantParserForSchema(fieldDefn);
            }
            case MULTI_ARRAY: {
                return this.multiDimArrayParserForSchema(fieldDefn);
            }
        }
        throw this.loader().unsupportedType(providedCol);
    }

    private ElementParser primitiveParserFor(FieldDefn fieldDefn) {
        ColumnMetadata providedCol = fieldDefn.providedColumn();
        if (providedCol.type() == TypeProtos.MinorType.VARCHAR) {
            return this.stringParserFor(fieldDefn);
        }
        return this.basicParserFor(fieldDefn);
    }

    private ElementParser basicParserFor(FieldDefn fieldDefn) {
        ColumnMetadata colSchema = fieldDefn.providedColumn().copy();
        ValueParser scalarParser = this.child.scalarParserFor(fieldDefn, colSchema);
        if (colSchema.isArray()) {
            return this.scalarArrayParserFor(scalarParser);
        }
        return scalarParser;
    }

    private ElementParser stringParserFor(FieldDefn fieldDefn) {
        String mode = fieldDefn.providedColumn().property("drill.json-mode");
        if (mode == null) {
            return this.basicParserFor(fieldDefn);
        }
        FieldParserFactory parserFactory = this.parserFactory();
        switch (mode) {
            case "text": {
                return parserFactory.textValueParser(this.varCharListenerFor(fieldDefn));
            }
            case "json": {
                return parserFactory.jsonTextParser(this.varCharListenerFor(fieldDefn));
            }
        }
        return this.basicParserFor(fieldDefn);
    }

    private VarCharListener varCharListenerFor(FieldDefn fieldDefn) {
        return new VarCharListener(this.loader, fieldDefn.scalarWriterFor(fieldDefn.providedColumn().copy()));
    }

    private ElementParser objectParserForSchema(FieldDefn fieldDefn) {
        ColumnMetadata providedCol = fieldDefn.providedColumn();
        ColumnMetadata colSchema = providedCol.cloneEmpty();
        TupleMetadata providedSchema = providedCol.tupleSchema();
        if (providedCol.isArray()) {
            return this.objectArrayParserFor(fieldDefn, colSchema, providedSchema);
        }
        return this.objectParserFor(fieldDefn, colSchema, providedSchema);
    }

    private ElementParser multiDimArrayParserForSchema(FieldDefn fieldDefn) {
        int dims = 1;
        ColumnMetadata elementSchema = fieldDefn.providedColumn();
        while (MetadataUtils.isRepeatedList(elementSchema)) {
            ++dims;
            Preconditions.checkArgument((elementSchema = elementSchema.childSchema()) != null);
        }
        ColumnMetadata colSchema = this.repeatedListSchemaFor(fieldDefn.key(), dims, elementSchema.cloneEmpty());
        ObjectWriter fieldWriter = fieldDefn.fieldWriterFor(colSchema);
        switch (elementSchema.structureType()) {
            case PRIMITIVE: {
                return this.multiDimScalarArrayFor(fieldWriter, dims);
            }
            case TUPLE: {
                return this.multiDimObjectArrayFor(fieldWriter, dims, elementSchema.tupleSchema());
            }
            case VARIANT: {
                return this.multiDimVariantArrayParserFor(fieldWriter, dims);
            }
        }
        throw this.loader().unsupportedType(fieldDefn.providedColumn());
    }

    private ElementParser variantParserForSchema(FieldDefn fieldDefn) {
        ColumnMetadata colSchema = fieldDefn.providedColumn().cloneEmpty();
        ObjectWriter fieldWriter = fieldDefn.fieldWriterFor(colSchema);
        if (colSchema.isArray()) {
            return this.variantArrayParserFor(fieldWriter.array());
        }
        return this.variantParserFor(fieldWriter.variant());
    }
}

