/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.loader;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.loader.TupleParser;
import org.apache.drill.exec.store.easy.json.parser.ArrayParser;
import org.apache.drill.exec.store.easy.json.parser.FullValueParser;
import org.apache.drill.exec.store.easy.json.parser.ObjectParser;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.vector.accessor.VariantWriter;

public class VariantParser
extends FullValueParser {
    private final JsonLoaderImpl loader;
    private final VariantWriter writer;

    public VariantParser(JsonLoaderImpl loader, VariantWriter writer) {
        super(loader.parser());
        this.loader = loader;
        this.writer = writer;
    }

    @Override
    protected void onValue(JsonToken token, TokenIterator tokenizer) {
        switch (token) {
            case VALUE_NULL: {
                this.writer.setNull();
                break;
            }
            case VALUE_TRUE: {
                this.writer.scalar(TypeProtos.MinorType.BIT).setBoolean(true);
                break;
            }
            case VALUE_FALSE: {
                this.writer.scalar(TypeProtos.MinorType.BIT).setBoolean(false);
                break;
            }
            case VALUE_NUMBER_INT: {
                this.writer.scalar(TypeProtos.MinorType.BIGINT).setLong(tokenizer.longValue());
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                this.writer.scalar(TypeProtos.MinorType.FLOAT8).setDouble(tokenizer.doubleValue());
                break;
            }
            case VALUE_STRING: {
                this.writer.scalar(TypeProtos.MinorType.VARCHAR).setString(tokenizer.stringValue());
                break;
            }
            default: {
                throw tokenizer.invalidValue(token);
            }
        }
    }

    @Override
    protected ObjectParser buildObjectParser(TokenIterator tokenizer) {
        return new VariantObjectParser(this.loader, this.writer);
    }

    @Override
    protected ArrayParser buildArrayParser(TokenIterator tokenizer) {
        return null;
    }

    private static class VariantObjectParser
    extends TupleParser {
        private final VariantWriter writer;

        public VariantObjectParser(JsonLoaderImpl loader, VariantWriter writer) {
            super(loader, writer.tuple(), null);
            this.writer = writer;
        }

        @Override
        public void onStart() {
            this.writer.setType(TypeProtos.MinorType.MAP);
        }
    }
}

