/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.parser;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.parser.AbstractElementParser;
import org.apache.drill.exec.store.easy.json.parser.ArrayParser;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;

public class ArrayValueParser
extends AbstractElementParser {
    protected final ArrayParser arrayParser;

    public ArrayValueParser(ArrayParser arrayParser) {
        super(arrayParser.structParser());
        this.arrayParser = arrayParser;
    }

    @Override
    public void parse(TokenIterator tokenizer) {
        JsonToken token = tokenizer.requireNext();
        if (token == JsonToken.START_ARRAY) {
            this.arrayParser.parse(tokenizer);
        } else if (token != JsonToken.VALUE_NULL) {
            if (token.isScalarValue()) {
                tokenizer.unget(token);
                this.parseValue(tokenizer);
            } else {
                throw this.errorFactory().structureError("JSON array expected");
            }
        }
    }

    protected void parseValue(TokenIterator tokenizer) {
        throw this.errorFactory().structureError("JSON array expected");
    }

    public static class LenientArrayValueParser
    extends ArrayValueParser {
        public LenientArrayValueParser(ArrayParser arrayParser) {
            super(arrayParser);
        }

        @Override
        protected void parseValue(TokenIterator tokenizer) {
            this.arrayParser.elementParser().parse(tokenizer);
        }
    }
}

