/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.parser;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.collections4.IterableUtils;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.store.easy.json.parser.ErrorFactory;
import org.apache.drill.exec.store.easy.json.parser.FieldParserFactory;
import org.apache.drill.exec.store.easy.json.parser.JsonStructureOptions;
import org.apache.drill.exec.store.easy.json.parser.MessageParser;
import org.apache.drill.exec.store.easy.json.parser.ObjectParser;
import org.apache.drill.exec.store.easy.json.parser.RootParser;
import org.apache.drill.exec.store.easy.json.parser.SimpleMessageParser;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonStructureParser {
    protected static final Logger logger = LoggerFactory.getLogger(JsonStructureParser.class);
    private final JsonStructureOptions options;
    private final ErrorFactory errorFactory;
    private final TokenIterator tokenizer;
    private final RootParser rootState;
    private final FieldParserFactory fieldFactory;
    private final Map<String, Object> listenerColumnMap;
    private int errorRecoveryCount;

    private JsonStructureParser(JsonStructureParserBuilder builder) {
        this.options = Preconditions.checkNotNull(builder.options);
        this.errorFactory = Preconditions.checkNotNull(builder.errorFactory);
        ObjectMapper mapper = JacksonUtils.createObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS.mappedFeature(), this.options.allowNanInf).configure(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER.mappedFeature(), this.options.enableEscapeAnyChar);
        boolean isStream = !IterableUtils.isEmpty((Iterable)builder.streams);
        Function<InputStream, JsonParser> parserFunction = stream -> this.getJsonParser(builder, mapper, (InputStream)stream, isStream);
        this.tokenizer = new TokenIterator(builder.streams, parserFunction, this.options, this.errorFactory());
        this.fieldFactory = new FieldParserFactory(this, Preconditions.checkNotNull(builder.parserFactory));
        this.listenerColumnMap = builder.listenerColumnMap;
        this.rootState = builder.messageParser == null ? this.makeRootState() : this.makeCustomRoot(builder.messageParser);
    }

    private JsonParser getJsonParser(JsonStructureParserBuilder builder, ObjectMapper mapper, InputStream stream, boolean isStream) {
        try {
            if (isStream) {
                return mapper.getFactory().createParser(stream);
            }
            return mapper.getFactory().createParser(Preconditions.checkNotNull(builder.reader));
        }
        catch (JsonParseException e) {
            throw this.errorFactory().parseError("Failed to create the JSON parser", e);
        }
        catch (IOException e) {
            throw this.errorFactory().ioException(e);
        }
    }

    public JsonStructureOptions options() {
        return this.options;
    }

    public ErrorFactory errorFactory() {
        return this.errorFactory;
    }

    public FieldParserFactory fieldFactory() {
        return this.fieldFactory;
    }

    private RootParser makeRootState() {
        JsonToken token = this.tokenizer.next();
        if (token == null) {
            return null;
        }
        switch (token) {
            case START_ARRAY: {
                if (this.options.skipOuterList) {
                    return new RootParser.RootArrayParser(this);
                }
                throw this.errorFactory().structureError("JSON includes an outer array, but outer array support is not enabled");
            }
            case START_OBJECT: {
                this.tokenizer.unget(token);
                return new RootParser.RootObjectParser(this);
            }
        }
        throw this.errorFactory().syntaxError(token);
    }

    private RootParser makeCustomRoot(MessageParser messageParser) {
        try {
            if (!messageParser.parsePrefix(this.tokenizer)) {
                return null;
            }
        }
        catch (MessageParser.MessageContextException e) {
            throw this.errorFactory.messageParseError(e);
        }
        JsonToken token = this.tokenizer.requireNext();
        switch (token) {
            case VALUE_NULL: {
                return null;
            }
            case START_ARRAY: {
                return new RootParser.EmbeddedArrayParser(this, messageParser);
            }
            case START_OBJECT: {
                this.tokenizer.unget(token);
                return new RootParser.EmbeddedObjectParser(this, messageParser);
            }
        }
        throw new IllegalStateException("Message parser misbehaved: " + token.name());
    }

    public boolean next() {
        if (this.rootState == null) {
            return false;
        }
        while (true) {
            try {
                return this.rootState.parseRoot(this.tokenizer);
            }
            catch (TokenIterator.RecoverableJsonException e) {
                if (this.recover()) continue;
                throw this.errorFactory().structureError("Unrecoverable error - " + e.getMessage());
            }
            break;
        }
    }

    private boolean recover() {
        logger.warn("Attempting recovery from JSON syntax error. " + this.tokenizer.context());
        boolean firstAttempt = true;
        while (true) {
            JsonToken token2;
            try {
                while (true) {
                    if (this.tokenizer.getParser().isClosed()) {
                        throw this.errorFactory().unrecoverableError();
                    }
                    token2 = this.tokenizer.next();
                    if (token2 == null) {
                        if (firstAttempt && !this.options().skipMalformedDocument) {
                            throw this.errorFactory().unrecoverableError();
                        }
                        return false;
                    }
                    if (token2 == JsonToken.NOT_AVAILABLE) {
                        return false;
                    }
                    if (token2 != JsonToken.END_OBJECT) {
                        firstAttempt = false;
                        continue;
                    }
                    break;
                }
            }
            catch (TokenIterator.RecoverableJsonException token2) {
                continue;
            }
            try {
                token2 = this.tokenizer.next();
                if (token2 == null || token2 == JsonToken.NOT_AVAILABLE) {
                    return false;
                }
                if (token2 != JsonToken.START_OBJECT) continue;
                logger.warn("Attempting to resume JSON parse. " + this.tokenizer.context());
                this.tokenizer.unget(token2);
                ++this.errorRecoveryCount;
                return true;
            }
            catch (TokenIterator.RecoverableJsonException recoverableJsonException) {
                continue;
            }
            break;
        }
    }

    public int recoverableErrorCount() {
        return this.errorRecoveryCount;
    }

    public int lineNumber() {
        return this.tokenizer.lineNumber();
    }

    public int columnNumber() {
        return this.tokenizer.columnNumber();
    }

    public String token() {
        return this.tokenizer.token();
    }

    public void close() {
        if (this.errorRecoveryCount > 0) {
            logger.warn("Read JSON input with {} recoverable error(s).", (Object)this.errorRecoveryCount);
        }
        try {
            this.tokenizer.close();
        }
        catch (IOException e) {
            logger.warn("Ignored failure when closing JSON source", (Throwable)e);
        }
    }

    public static class JsonStructureParserBuilder {
        private Iterable<InputStream> streams;
        private Reader reader;
        private JsonStructureOptions options;
        private Function<JsonStructureParser, ObjectParser> parserFactory;
        private ErrorFactory errorFactory;
        private String dataPath;
        private MessageParser messageParser;
        private Map<String, Object> listenerColumnMap;

        public JsonStructureParserBuilder options(JsonStructureOptions options) {
            this.options = options;
            return this;
        }

        public JsonStructureParserBuilder parserFactory(Function<JsonStructureParser, ObjectParser> parserFactory) {
            this.parserFactory = parserFactory;
            return this;
        }

        public JsonStructureParserBuilder errorFactory(ErrorFactory errorFactory) {
            this.errorFactory = errorFactory;
            return this;
        }

        public JsonStructureParserBuilder fromStream(InputStream ... stream) {
            this.streams = Arrays.asList(stream);
            return this;
        }

        public JsonStructureParserBuilder fromStream(Iterable<InputStream> streams) {
            this.streams = streams;
            return this;
        }

        public JsonStructureParserBuilder fromReader(Reader reader) {
            this.reader = reader;
            return this;
        }

        public JsonStructureParserBuilder messageParser(MessageParser messageParser) {
            this.messageParser = messageParser;
            return this;
        }

        public JsonStructureParserBuilder dataPath(String dataPath) {
            this.dataPath = dataPath;
            return this;
        }

        public JsonStructureParserBuilder listenerColumnMap(Map<String, Object> listenerColumnMap) {
            this.listenerColumnMap = listenerColumnMap;
            return this;
        }

        public JsonStructureParser build() {
            if (this.dataPath != null) {
                this.dataPath = this.dataPath.trim();
                String string = this.dataPath = this.dataPath.isEmpty() ? null : this.dataPath;
            }
            if (this.dataPath != null && this.messageParser == null) {
                this.messageParser = new SimpleMessageParser(this.dataPath, this.listenerColumnMap);
            }
            return new JsonStructureParser(this);
        }
    }
}

