/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.parser;

import com.fasterxml.jackson.core.JsonToken;
import java.util.Map;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.apache.drill.exec.store.easy.json.parser.AbstractElementParser;
import org.apache.drill.exec.store.easy.json.parser.DummyValueParser;
import org.apache.drill.exec.store.easy.json.parser.ElementParser;
import org.apache.drill.exec.store.easy.json.parser.JsonStructureParser;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectParser
extends AbstractElementParser {
    protected static final Logger logger = LoggerFactory.getLogger(ObjectParser.class);
    private final Map<String, ElementParser> members = CaseInsensitiveMap.newHashMap();

    public ObjectParser(JsonStructureParser structParser) {
        super(structParser);
    }

    @VisibleForTesting
    public ElementParser fieldParser(String key) {
        return this.members.get(key);
    }

    protected void onStart() {
    }

    protected abstract ElementParser onField(String var1, TokenIterator var2);

    protected void onEnd() {
    }

    @Override
    public void parse(TokenIterator tokenizer) {
        this.onStart();
        block4: while (true) {
            JsonToken token = tokenizer.requireNext();
            switch (token) {
                case END_OBJECT: {
                    break block4;
                }
                case FIELD_NAME: {
                    this.parseMember(tokenizer);
                    break;
                }
                default: {
                    throw this.errorFactory().syntaxError(token);
                }
            }
        }
        this.onEnd();
    }

    private void parseMember(TokenIterator tokenizer) {
        String key = tokenizer.textValue().trim();
        ElementParser fieldParser = this.members.get(key);
        if (fieldParser == null) {
            fieldParser = this.detectValueParser(key, tokenizer);
            this.members.put(key, fieldParser);
        }
        fieldParser.parse(tokenizer);
    }

    private ElementParser detectValueParser(String key, TokenIterator tokenizer) {
        if (key.isEmpty()) {
            throw this.errorFactory().structureError("Drill does not allow empty keys in JSON key/value pairs");
        }
        ElementParser fieldParser = this.onField(key, tokenizer);
        if (fieldParser == null) {
            logger.warn("No JSON element parser returned for field {}, assuming unprojected", (Object)key);
            return DummyValueParser.INSTANCE;
        }
        return fieldParser;
    }

    public ElementParser replaceFieldParser(String key, ElementParser fieldParser) {
        this.members.put(key, fieldParser);
        return fieldParser;
    }
}

