/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.parser;

import com.fasterxml.jackson.core.JsonToken;
import java.util.Map;
import org.apache.drill.exec.store.easy.json.parser.DummyValueParser;
import org.apache.drill.exec.store.easy.json.parser.MessageParser;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class SimpleMessageParser
implements MessageParser {
    private final String[] path;
    private final Map<String, Object> listenerColumnMap;

    public SimpleMessageParser(String dataPath, Map<String, Object> listenerColumnMap) {
        this.path = dataPath.split("/");
        Preconditions.checkArgument(this.path.length > 0, "Data path should not be empty.");
        this.listenerColumnMap = listenerColumnMap;
    }

    @Override
    public boolean parsePrefix(TokenIterator tokenizer) throws MessageParser.MessageContextException {
        JsonToken token = tokenizer.next();
        if (token == null) {
            return false;
        }
        if (token != JsonToken.START_OBJECT) {
            throw new MessageParser.MessageContextException(token, this.path[0], "Unexpected top-level array");
        }
        return this.parseToElement(tokenizer, 0);
    }

    private boolean parseToElement(TokenIterator tokenizer, int level) throws MessageParser.MessageContextException {
        while (true) {
            JsonToken token = tokenizer.requireNext();
            switch (token) {
                case FIELD_NAME: {
                    break;
                }
                case END_OBJECT: {
                    return false;
                }
                default: {
                    throw new MessageParser.MessageContextException(token, this.path[0], "Unexpected token");
                }
            }
            String fieldName = tokenizer.textValue();
            if (fieldName.equals(this.path[level])) {
                return this.parseInnerLevel(tokenizer, level);
            }
            if (this.listenerColumnMap != null && this.listenerColumnMap.containsKey(fieldName)) {
                this.skipElementButRetainValue(tokenizer, fieldName);
                continue;
            }
            this.skipElement(tokenizer);
        }
    }

    private boolean parseInnerLevel(TokenIterator tokenizer, int level) throws MessageParser.MessageContextException {
        JsonToken token = tokenizer.requireNext();
        if (level == this.path.length - 1) {
            switch (token) {
                case VALUE_NULL: 
                case START_ARRAY: 
                case START_OBJECT: {
                    tokenizer.unget(token);
                    return true;
                }
            }
            throw new MessageParser.MessageContextException(token, this.path[level], "Expected JSON array for final path element");
        }
        if (token != JsonToken.START_OBJECT) {
            throw new MessageParser.MessageContextException(token, this.path[level], "Expected JSON object");
        }
        return this.parseToElement(tokenizer, level + 1);
    }

    private void skipElementButRetainValue(TokenIterator tokenizer, String fieldName) {
        String value;
        JsonToken token = ((DummyValueParser)DummyValueParser.INSTANCE).parseAndReturnToken(tokenizer);
        switch (token) {
            case VALUE_NULL: {
                Object var4_4 = null;
            }
            case VALUE_TRUE: {
                value = Boolean.TRUE.toString();
                break;
            }
            case VALUE_FALSE: {
                value = Boolean.FALSE.toString();
                break;
            }
            case VALUE_NUMBER_INT: {
                value = Long.toString(tokenizer.longValue());
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                value = Double.toString(tokenizer.doubleValue());
                break;
            }
            case VALUE_STRING: {
                value = tokenizer.stringValue();
                break;
            }
            default: {
                throw tokenizer.invalidValue(token);
            }
        }
        this.listenerColumnMap.put(fieldName, value);
    }

    private void skipElement(TokenIterator tokenizer) {
        DummyValueParser.INSTANCE.parse(tokenizer);
    }

    @Override
    public void parseSuffix(TokenIterator tokenizer) {
    }
}

