/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.reader;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.io.InputStream;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.store.easy.json.JsonProcessor;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public abstract class BaseJsonProcessor
implements JsonProcessor {
    private static final ObjectMapper DEFAULT_MAPPER = BaseJsonProcessor.getDefaultMapper();
    private static final ObjectMapper NAN_INF_MAPPER = BaseJsonProcessor.getDefaultMapper().configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
    private static final ObjectMapper ESCAPE_ANY_MAPPER = BaseJsonProcessor.getDefaultMapper().configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
    private static final ObjectMapper NAN_INF_AND_ESCAPE_ANY_MAPPER = BaseJsonProcessor.getDefaultMapper().configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true).configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
    private static final String JACKSON_PARSER_EOF_FILE_MSG = "Unexpected end-of-input:";
    private final boolean enableNanInf;
    private final boolean enableEscapeAnyChar;
    protected JsonParser parser;
    protected DrillBuf workBuf;
    protected JsonToken lastSeenJsonToken;
    boolean ignoreJSONParseErrors;
    protected String currentFieldName;

    public static ObjectMapper getDefaultMapper() {
        return JacksonUtils.createObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
    }

    @Override
    public boolean ignoreJSONParseError() {
        return this.ignoreJSONParseErrors;
    }

    @Override
    public void setIgnoreJSONParseErrors(boolean ignoreJSONParseErrors) {
        this.ignoreJSONParseErrors = ignoreJSONParseErrors;
    }

    public BaseJsonProcessor(DrillBuf workBuf, boolean enableNanInf, boolean enableEscapeAnyChar) {
        this.enableNanInf = enableNanInf;
        this.enableEscapeAnyChar = enableEscapeAnyChar;
        workBuf = Preconditions.checkNotNull(workBuf);
    }

    @Override
    public void setSource(InputStream is) throws IOException {
        this.parser = this.enableNanInf && this.enableEscapeAnyChar ? NAN_INF_AND_ESCAPE_ANY_MAPPER.getFactory().createParser(is) : (this.enableNanInf ? NAN_INF_MAPPER.getFactory().createParser(is) : (this.enableEscapeAnyChar ? ESCAPE_ANY_MAPPER.getFactory().createParser(is) : DEFAULT_MAPPER.getFactory().createParser(is)));
    }

    @Override
    public void setSource(JsonNode node) {
        this.parser = new TreeTraversingParser(node);
    }

    public String toString() {
        JsonLocation location = this.parser.getCurrentLocation();
        return this.getClass().getSimpleName() + "[Line=" + location.getLineNr() + ", Column=" + (location.getColumnNr() + 1) + ", Field=" + this.getCurrentField() + "]";
    }

    @Override
    public UserException.Builder getExceptionWithContext(UserException.Builder builder, String message) {
        builder.message(message, new Object[0]);
        JsonLocation location = this.parser.getCurrentLocation();
        builder.addContext("Line", location.getLineNr()).addContext("Column", location.getColumnNr() + 1);
        String fieldName = this.getCurrentField();
        if (fieldName != null) {
            builder.addContext("Field", fieldName);
        }
        return builder;
    }

    @Override
    public UserException.Builder getExceptionWithContext(Throwable e, String message) {
        UserException.Builder exceptionBuilder = UserException.dataReadError(e);
        return this.getExceptionWithContext(exceptionBuilder, message);
    }

    protected JsonExceptionProcessingState processJSONException() throws IOException {
        while (!this.parser.isClosed()) {
            try {
                JsonToken currentToken = this.parser.nextToken();
                if (currentToken == JsonToken.START_OBJECT && (this.lastSeenJsonToken == JsonToken.END_OBJECT || this.lastSeenJsonToken == null)) {
                    this.lastSeenJsonToken = currentToken;
                    break;
                }
                this.lastSeenJsonToken = currentToken;
            }
            catch (JsonParseException ex1) {
                if (!ex1.getOriginalMessage().startsWith(JACKSON_PARSER_EOF_FILE_MSG)) continue;
                return JsonExceptionProcessingState.END_OF_STREAM;
            }
        }
        return JsonExceptionProcessingState.PROC_SUCCEED;
    }

    protected String getCurrentField() {
        return this.currentFieldName;
    }

    public static enum JsonExceptionProcessingState {
        END_OF_STREAM,
        PROC_SUCCEED;

    }
}

