/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.values;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class BinaryValueListener
extends ScalarListener {
    private static final byte[] EMPTY_BYTES = new byte[0];

    public BinaryValueListener(JsonLoaderImpl loader, ScalarWriter writer) {
        super(loader, writer);
    }

    @Override
    public void onValue(JsonToken token, TokenIterator tokenizer) {
        switch (token) {
            case VALUE_NULL: {
                this.setNull();
                break;
            }
            case VALUE_STRING: {
                byte[] value = tokenizer.binaryValue();
                this.writer.setBytes(value, value.length);
                break;
            }
            default: {
                throw tokenizer.invalidValue(token);
            }
        }
    }

    @Override
    protected void setArrayNull() {
        this.writer.setBytes(EMPTY_BYTES, 0);
    }
}

