/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.values;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;
import org.apache.drill.exec.store.easy.json.values.TimestampValueListener;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class DateValueListener
extends ScalarListener {
    public DateValueListener(JsonLoaderImpl loader, ScalarWriter writer) {
        super(loader, writer);
    }

    @Override
    public void onValue(JsonToken token, TokenIterator tokenizer) {
        switch (token) {
            case VALUE_NULL: {
                this.setNull();
                break;
            }
            case VALUE_NUMBER_INT: {
                this.addValueToListenerMap(this.writer.schema().name(), tokenizer.longValue());
                this.writer.setLong(tokenizer.longValue());
                break;
            }
            case VALUE_STRING: {
                try {
                    String formatValue = this.schema().format();
                    DateTimeFormatter dateTimeFormatter = formatValue == null ? DateTimeFormatter.ISO_LOCAL_DATE : DateTimeFormatter.ofPattern(formatValue);
                    LocalDate localDate = LocalDate.parse(tokenizer.stringValue(), dateTimeFormatter);
                    this.writer.setLong(Duration.between(TimestampValueListener.LOCAL_EPOCH, localDate.atStartOfDay()).toMillis());
                    this.addValueToListenerMap(this.writer.schema().name(), Duration.between(TimestampValueListener.LOCAL_EPOCH, localDate.atStartOfDay()).toMillis());
                    break;
                }
                catch (Exception e) {
                    throw this.loader.dataConversionError(this.schema(), "date", tokenizer.stringValue());
                }
            }
            default: {
                throw tokenizer.invalidValue(token);
            }
        }
    }
}

